/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.loading.LogMarkers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public final class ClasspathResourceUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathResourceUtils.class);

    private ClasspathResourceUtils() {
    }

    public static List<Path> findFileSystemRootsOfFileOnClasspath(String relativePath) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (ClasspathResourceUtils.class.getModule().isNamed()) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return ClasspathResourceUtils.findFileSystemRootsOfFileOnClasspath(classLoader, relativePath);
    }

    public static Path findJarPathFor(String resourceName, String jarName, URL resource) {
        try {
            Path path;
            URI uri = resource.toURI();
            if (uri.getScheme().equals("jar") && uri.getRawSchemeSpecificPart().contains("!/")) {
                int lastExcl = uri.getRawSchemeSpecificPart().lastIndexOf("!/");
                path = Paths.get(new URI(uri.getRawSchemeSpecificPart().substring(0, lastExcl)));
            } else {
                path = Paths.get(new URI("file://" + uri.getRawSchemeSpecificPart().substring(0, uri.getRawSchemeSpecificPart().length() - resourceName.length())));
            }
            return path;
        }
        catch (NullPointerException | URISyntaxException e) {
            LOGGER.error(LogMarkers.SCAN, "Failed to find JAR for class {} - {}", (Object)resourceName, (Object)jarName);
            throw new RuntimeException("Unable to locate " + resourceName + " - " + jarName, e);
        }
    }

    public static Path getRootFromResourceUrl(String relativePath, URL resourceUrl) {
        Path resourcePath;
        if ("jar".equals(resourceUrl.getProtocol())) {
            URI fileUri = URI.create(resourceUrl.toString().split("!")[0].substring("jar:".length()));
            return Paths.get(fileUri);
        }
        try {
            resourcePath = Paths.get(resourceUrl.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to convert " + String.valueOf(resourceUrl) + " to URI");
        }
        for (Path current = Paths.get(relativePath, new String[0]); current != null; current = current.getParent()) {
            if ((resourcePath = resourcePath.getParent()) != null) continue;
            throw new IllegalArgumentException("Resource " + String.valueOf(resourceUrl) + " did not have same nesting depth as " + relativePath);
        }
        return resourcePath;
    }

    @Nullable
    public static Path findFileSystemRootOfFileOnClasspath(ClassLoader classLoader, String relativePath) {
        URL resource = classLoader.getResource(relativePath);
        if (resource == null) {
            return null;
        }
        return ClasspathResourceUtils.getRootFromResourceUrl(relativePath, resource);
    }

    public static List<Path> findFileSystemRootsOfFileOnClasspath(ClassLoader classLoader, String relativePath) {
        Iterator<URL> resourceIt;
        try {
            resourceIt = classLoader.getResources(relativePath).asIterator();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to enumerate classpath locations of " + relativePath);
        }
        LinkedHashSet<Path> result = new LinkedHashSet<Path>();
        while (resourceIt.hasNext()) {
            URL resourceUrl = resourceIt.next();
            result.add(ClasspathResourceUtils.getRootFromResourceUrl(relativePath, resourceUrl));
        }
        return new ArrayList<Path>(result);
    }

    public static Path findFileSystemRootOfFileOnClasspath(String relativePath) {
        List<Path> paths = ClasspathResourceUtils.findFileSystemRootsOfFileOnClasspath(relativePath);
        if (paths.isEmpty()) {
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.failed_to_find_on_classpath", relativePath));
        }
        if (paths.size() > 1) {
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.multiple_copies_on_classpath", relativePath, paths));
        }
        return paths.getFirst();
    }

    public static Set<Path> getAllClasspathItems(ClassLoader loader) {
        HashSet<Path> result = new HashSet<Path>();
        if (loader == ClassLoader.getSystemClassLoader()) {
            return Arrays.stream(System.getProperty("java.class.path").split(File.pathSeparator)).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toSet());
        }
        if (loader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)loader;
            for (URL url : urlClassLoader.getURLs()) {
                if (!"file".equals(url.getProtocol())) continue;
                try {
                    result.add(Paths.get(url.toURI()));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        if (loader.getParent() != null && loader.getParent() != ClassLoader.getPlatformClassLoader()) {
            result.addAll(ClasspathResourceUtils.getAllClasspathItems(loader.getParent()));
        }
        return result;
    }
}

