/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.classloading.transformation;

import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.SequencedMap;
import java.util.Set;
import java.util.function.Function;
import net.neoforged.fml.CrashReportCallables;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.classloading.transformation.ClassTransformStatistics;
import net.neoforged.fml.loading.toposort.TopologicalSort;
import net.neoforged.fml.util.ServiceLoaderUtil;
import net.neoforged.neoforgespi.transformation.BytecodeProvider;
import net.neoforged.neoforgespi.transformation.ClassProcessor;
import net.neoforged.neoforgespi.transformation.ClassProcessorIds;
import net.neoforged.neoforgespi.transformation.ClassProcessorProvider;
import net.neoforged.neoforgespi.transformation.ProcessorName;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.Type;
import org.slf4j.Logger;

@ApiStatus.Internal
public final class ClassProcessorSet {
    private final List<ClassProcessor> sortedProcessors;
    private final Set<ProcessorName> markerProcessors;
    private final Set<String> generatedPackages;
    private final SequencedMap<ProcessorName, ClassProcessor> processors;
    private final Set<ProcessorName> allowedToRecomputeFrames;
    private boolean linked;

    private ClassProcessorSet(List<ClassProcessor> sortedProcessors, Set<ProcessorName> markers, Set<String> generatedPackages, Set<ProcessorName> allowedToRecomputeFrames) {
        CrashReportCallables.registerCrashCallable("Class Processors", () -> ClassTransformStatistics.computeCrashReportEntry(this));
        this.sortedProcessors = List.copyOf(sortedProcessors);
        this.markerProcessors = Set.copyOf(markers);
        this.generatedPackages = Set.copyOf(generatedPackages);
        LinkedHashMap<ProcessorName, ClassProcessor> processors = LinkedHashMap.newLinkedHashMap(sortedProcessors.size());
        for (ClassProcessor processor : sortedProcessors) {
            processors.put(processor.name(), processor);
        }
        this.allowedToRecomputeFrames = Set.copyOf(allowedToRecomputeFrames);
        this.processors = Collections.unmodifiableSequencedMap(processors);
    }

    public static ClassProcessorSet of(ClassProcessor ... processors) {
        return ClassProcessorSet.builder().addProcessors(Arrays.asList(processors)).build();
    }

    boolean canRecomputeFrames(ProcessorName name) {
        return this.allowedToRecomputeFrames.contains(name);
    }

    public boolean isMarker(ClassProcessor processor) {
        return this.markerProcessors.contains(processor.name());
    }

    public Set<String> getGeneratedPackages() {
        return this.generatedPackages;
    }

    List<ClassProcessor> getSortedProcessors() {
        return this.sortedProcessors;
    }

    public List<ClassProcessor> transformersFor(Type classDesc, boolean isEmpty, ProcessorName upToTransformer) {
        ArrayList<ClassProcessor> out = new ArrayList<ClassProcessor>();
        boolean includesComputingFrames = false;
        for (ClassProcessor transformer : this.sortedProcessors) {
            if (upToTransformer != null && upToTransformer.equals(transformer.name())) break;
            if (ClassProcessorIds.COMPUTING_FRAMES.equals(transformer.name())) {
                includesComputingFrames = true;
                out.add(transformer);
                continue;
            }
            ClassTransformStatistics.incrementAskedForTransform(transformer);
            ClassProcessor.SelectionContext context = new ClassProcessor.SelectionContext(classDesc, isEmpty);
            if (!transformer.handlesClass(context)) continue;
            ClassTransformStatistics.incrementTransforms(transformer);
            out.add(transformer);
        }
        if (out.size() == 1 && includesComputingFrames) {
            return List.of();
        }
        return out;
    }

    public void link(Function<ProcessorName, BytecodeProvider> bytecodeProviderLookup) {
        if (this.linked) {
            throw new IllegalStateException("This set of class processors is already linked.");
        }
        this.linked = true;
        for (ClassProcessor processor : this.sortedProcessors) {
            ClassProcessor.LinkContext context = new ClassProcessor.LinkContext(this.processors, bytecodeProviderLookup.apply(processor.name()));
            processor.link(context);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final Logger LOGGER = LogUtils.getLogger();
        private final List<ClassProcessor> processors = new ArrayList<ClassProcessor>();
        private final Set<ProcessorName> markers = new HashSet<ProcessorName>();

        private Builder() {
        }

        public Builder markMarker(ProcessorName name) {
            this.markers.add(name);
            return this;
        }

        public Builder addProcessor(ClassProcessor toAdd) {
            this.processors.add(toAdd);
            return this;
        }

        public Builder addProcessors(Collection<ClassProcessor> toAdd) {
            this.processors.addAll(toAdd);
            return this;
        }

        public Builder addProcessorProviders(Collection<ClassProcessorProvider> providers) {
            ClassProcessorProvider.Context context = new ClassProcessorProvider.Context();
            for (ClassProcessorProvider provider : providers) {
                try {
                    provider.createProcessors(context, this.processors::add);
                }
                catch (Exception e) {
                    String sourceFile = ServiceLoaderUtil.identifySourcePath(provider);
                    ModLoader.addLoadingIssue(ModLoadingIssue.error("fml.modloadingissue.coremod_error", provider.getClass().getName(), sourceFile).withCause(e));
                }
            }
            return this;
        }

        private static List<ClassProcessor> sortProcessors(List<ClassProcessor> allProcessors, Set<ProcessorName> allowedToRecomputeFrames) {
            HashMap<ProcessorName, ClassProcessor> transformers = new HashMap<ProcessorName, ClassProcessor>();
            MutableGraph graph = GraphBuilder.directed().build();
            ClassProcessor specialComputeFramesNode = Builder.createSpecialComputeFramesNode();
            graph.addNode((Object)specialComputeFramesNode);
            transformers.put(specialComputeFramesNode.name(), specialComputeFramesNode);
            for (ClassProcessor transformer : allProcessors) {
                if (transformers.containsKey(transformer.name())) {
                    LOGGER.error("Duplicate transformers with name {}, of types {} and {}", new Object[]{transformer.name(), ((ClassProcessor)transformers.get(transformer.name())).getClass().getName(), transformer.getClass().getName()});
                    throw new IllegalStateException("Duplicate transformers with name: " + String.valueOf(transformer.name()));
                }
                graph.addNode((Object)transformer);
                transformers.put(transformer.name(), transformer);
            }
            for (ClassProcessor self : transformers.values()) {
                ClassProcessor target;
                for (ProcessorName targetName : self.runsBefore()) {
                    target = (ClassProcessor)transformers.get(targetName);
                    if (target == self || target == null) continue;
                    graph.putEdge((Object)self, (Object)target);
                }
                for (ProcessorName targetName : self.runsAfter()) {
                    target = (ClassProcessor)transformers.get(targetName);
                    if (target == self || target == null) continue;
                    graph.putEdge((Object)target, (Object)self);
                }
            }
            List<ClassProcessor> sorted = TopologicalSort.topologicalSort(graph, Comparator.comparing(ClassProcessor::orderingHint).thenComparing(ClassProcessor::name));
            for (ClassProcessor node : Graphs.reachableNodes((Graph)graph, (Object)specialComputeFramesNode)) {
                allowedToRecomputeFrames.add(node.name());
            }
            return sorted;
        }

        private static ClassProcessor createSpecialComputeFramesNode() {
            return new ClassProcessor(){

                @Override
                public ProcessorName name() {
                    return ClassProcessorIds.COMPUTING_FRAMES;
                }

                @Override
                public Set<ProcessorName> runsAfter() {
                    return Set.of();
                }

                @Override
                public ClassProcessor.OrderingHint orderingHint() {
                    return ClassProcessor.OrderingHint.EARLY;
                }

                @Override
                public boolean handlesClass(ClassProcessor.SelectionContext context) {
                    return false;
                }

                @Override
                public ClassProcessor.ComputeFlags processClass(ClassProcessor.TransformationContext context) {
                    return ClassProcessor.ComputeFlags.NO_REWRITE;
                }
            };
        }

        public ClassProcessorSet build() {
            HashSet<ProcessorName> allowedToRecomputeFrames = new HashSet<ProcessorName>();
            List<ClassProcessor> sortedProcessors = Builder.sortProcessors(this.processors, allowedToRecomputeFrames);
            HashSet<String> packageNames = new HashSet<String>();
            for (ClassProcessor factory : this.processors) {
                packageNames.addAll(factory.generatesPackages());
            }
            return new ClassProcessorSet(sortedProcessors, this.markers, packageNames, allowedToRecomputeFrames);
        }
    }
}

