/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.jarcontents;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import net.neoforged.fml.jarcontents.CompositeJarContents;
import net.neoforged.fml.jarcontents.EmptyJarContents;
import net.neoforged.fml.jarcontents.FolderJarContents;
import net.neoforged.fml.jarcontents.JarFileContents;
import net.neoforged.fml.jarcontents.JarResource;
import net.neoforged.fml.jarcontents.JarResourceVisitor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface JarContents
extends Closeable {
    public static JarContents ofFilteredPaths(Collection<FilteredPath> paths) throws IOException {
        if (paths.isEmpty()) {
            throw new IllegalArgumentException("Cannot construct jar contents without any paths.");
        }
        ArrayList<JarContents> contents = new ArrayList<JarContents>(paths.size());
        ArrayList<PathFilter> filters = new ArrayList<PathFilter>(paths.size());
        for (FilteredPath filteredPath : paths) {
            if (!Files.exists(filteredPath.path, new LinkOption[0])) continue;
            contents.add(JarContents.ofPath(filteredPath.path));
            filters.add(filteredPath.filter);
        }
        if (contents.isEmpty()) {
            String pathList = paths.stream().map(f -> f.path.toString()).collect(Collectors.joining(", "));
            throw new NoSuchFileException("At least one of the paths must exist when constructing jar contents: " + pathList);
        }
        if (contents.size() == 1 && filters.getFirst() == null) {
            return (JarContents)contents.getFirst();
        }
        return new CompositeJarContents(contents, filters);
    }

    public static JarContents ofPaths(Collection<Path> paths) throws IOException {
        if (paths.isEmpty()) {
            throw new IllegalArgumentException("Cannot construct jar contents without any paths.");
        }
        ArrayList<JarContents> contents = new ArrayList<JarContents>(paths.size());
        for (Path path : paths) {
            if (!Files.exists(path, new LinkOption[0])) continue;
            contents.add(JarContents.ofPath(path));
        }
        if (contents.isEmpty()) {
            throw new NoSuchFileException("At least one of the paths must exist when constructing jar contents: " + String.valueOf(paths));
        }
        if (contents.size() == 1) {
            return (JarContents)contents.getFirst();
        }
        return new CompositeJarContents(contents);
    }

    public static JarContents ofPath(Path path) throws IOException {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            return new JarFileContents(path);
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return new FolderJarContents(path);
        }
        throw new NoSuchFileException("Cannot construct mod container from missing " + String.valueOf(path));
    }

    public static JarContents empty(Path path) {
        return new EmptyJarContents(path);
    }

    public Optional<String> getChecksum();

    public Path getPrimaryPath();

    public Collection<Path> getContentRoots();

    @Nullable
    public JarResource get(String var1);

    public Optional<URI> findFile(String var1);

    @Nullable
    public InputStream openFile(String var1) throws IOException;

    default public byte @Nullable [] readFile(String relativePath) throws IOException {
        try (InputStream in = this.openFile(relativePath);){
            if (in == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = in.readAllBytes();
            return byArray;
        }
    }

    public boolean containsFile(String var1);

    public Manifest getManifest();

    default public void visitContent(JarResourceVisitor visitor) {
        this.visitContent("", visitor);
    }

    public void visitContent(String var1, JarResourceVisitor var2);

    public record FilteredPath(Path path, @Nullable PathFilter filter) {
        public FilteredPath(Path path) {
            this(path, null);
        }
    }

    @FunctionalInterface
    public static interface PathFilter {
        public boolean test(String var1);

        @Nullable
        public static PathFilter and(@Nullable PathFilter a, @Nullable PathFilter b) {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            return relativePath -> a.test(relativePath) && b.test(relativePath);
        }
    }
}

