/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery.locators;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.util.ClasspathResourceUtils;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import net.neoforged.neoforgespi.locating.IncompatibleFileReporting;
import net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes;

public class InDevJarLocator
implements IModFileCandidateLocator {
    @Override
    public void findCandidates(ILaunchContext context, IDiscoveryPipeline pipeline) {
        for (Path path : ClasspathResourceUtils.findFileSystemRootsOfFileOnClasspath("META-INF/neoforge.mods.toml")) {
            if (!Files.isRegularFile(path, new LinkOption[0])) continue;
            pipeline.addPath(path, ModFileDiscoveryAttributes.DEFAULT, IncompatibleFileReporting.WARN_ON_KNOWN_INCOMPATIBILITY);
        }
        for (Path path : ClasspathResourceUtils.findFileSystemRootsOfFileOnClasspath("META-INF/MANIFEST.MF")) {
            Manifest manifest;
            if (!Files.isRegularFile(path, new LinkOption[0])) continue;
            try (JarFile jarFile = new JarFile(path.toFile(), false);){
                manifest = jarFile.getManifest();
            }
            catch (IOException e) {
                pipeline.addIssue(ModLoadingIssue.error("fml.modloadingissue.brokenfile.invalidzip", new Object[0]).withAffectedPath(path).withCause(e));
                continue;
            }
            String modType = manifest.getMainAttributes().getValue(ModFile.TYPE);
            if (modType == null) continue;
            pipeline.addPath(path, ModFileDiscoveryAttributes.DEFAULT, IncompatibleFileReporting.WARN_ON_KNOWN_INCOMPATIBILITY);
        }
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    public String toString() {
        return "indevjar";
    }
}

