/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforgespi.language;

import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforgespi.language.IConfigurable;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModLanguageLoader;
import net.neoforged.neoforgespi.language.MavenVersionAdapter;
import net.neoforged.neoforgespi.locating.ForgeFeature;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;

public interface IModInfo {
    public static final VersionRange UNBOUNDED = MavenVersionAdapter.createFromVersionSpec(" ");

    public IModFileInfo getOwningFile();

    public IModLanguageLoader getLoader();

    public String getModId();

    public String getDisplayName();

    public String getDescription();

    public ArtifactVersion getVersion();

    public List<? extends ModVersion> getDependencies();

    public List<? extends ForgeFeature.Bound> getForgeFeatures();

    public String getNamespace();

    public Map<String, Object> getModProperties();

    public Optional<URL> getUpdateURL();

    public Optional<URL> getModURL();

    public Optional<String> getLogoFile();

    public boolean getLogoBlur();

    public IConfigurable getConfig();

    public static interface ModVersion {
        public String getModId();

        public VersionRange getVersionRange();

        public DependencyType getType();

        public Optional<String> getReason();

        public Ordering getOrdering();

        public DependencySide getSide();

        public void setOwner(IModInfo var1);

        public IModInfo getOwner();

        public Optional<URL> getReferralURL();
    }

    public static enum DependencyType {
        REQUIRED,
        OPTIONAL,
        INCOMPATIBLE,
        DISCOURAGED;

    }

    public static enum DependencySide {
        CLIENT(Dist.CLIENT),
        SERVER(Dist.DEDICATED_SERVER),
        BOTH(Dist.values());

        private final Dist[] dist;

        private DependencySide(Dist ... dist) {
            this.dist = dist;
        }

        public boolean isContained(Dist side) {
            return this == BOTH || this.dist[0] == side;
        }

        public boolean isCorrectSide() {
            return this == BOTH || FMLLoader.getCurrent().getDist().equals((Object)this.dist[0]);
        }
    }

    public static enum Ordering {
        BEFORE,
        AFTER,
        NONE;

    }
}

