/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.classloading;

import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleReader;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.stream.Stream;
import net.neoforged.fml.jarcontents.JarContents;

final class JarContentsModuleReader
implements ModuleReader {
    private final JarContents contents;

    public JarContentsModuleReader(JarContents contents) {
        this.contents = contents;
    }

    @Override
    public Optional<InputStream> open(String name) throws IOException {
        return Optional.ofNullable(this.contents.openFile(name));
    }

    @Override
    public Optional<URI> find(String name) {
        return this.contents.findFile(name);
    }

    @Override
    public Stream<String> list() {
        LinkedHashSet content = new LinkedHashSet();
        this.contents.visitContent((relativePath, resource) -> content.add(relativePath));
        return content.stream();
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.contents.toString();
    }
}

