/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.classloading.transformation;

import java.lang.module.Configuration;
import java.util.List;
import net.neoforged.fml.classloading.ModuleClassLoader;
import net.neoforged.fml.classloading.transformation.ClassHierarchyRecomputationContext;
import net.neoforged.fml.classloading.transformation.ClassProcessorAuditLog;
import net.neoforged.fml.classloading.transformation.ClassProcessorSet;
import net.neoforged.fml.classloading.transformation.ClassTransformer;
import net.neoforged.neoforgespi.transformation.ClassProcessorIds;
import net.neoforged.neoforgespi.transformation.ProcessorName;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class TransformingClassLoader
extends ModuleClassLoader {
    private final ClassTransformer classTransformer;

    @VisibleForTesting
    public TransformingClassLoader(ClassProcessorSet classProcessorSet, ClassProcessorAuditLog auditTrail, Configuration configuration, List<ModuleLayer> parentLayers, ClassLoader parentClassLoader) {
        super("TRANSFORMER", configuration, parentLayers, parentClassLoader);
        this.classTransformer = new ClassTransformer(classProcessorSet, auditTrail);
        classProcessorSet.link(processorName -> className -> this.buildTransformedClassNodeFor(className, (ProcessorName)processorName));
    }

    @Override
    protected byte[] maybeTransformClassBytes(byte[] bytes, String name, @Nullable String upToTransformer) {
        ProcessorName upToTransformerName = upToTransformer == null ? null : ProcessorName.parse(upToTransformer);
        return this.classTransformer.transform(bytes, name, upToTransformerName, new ClassHierarchyRecomputationContext(){

            @Override
            @Nullable
            public Class<?> findLoadedClass(String name) {
                return TransformingClassLoader.this.getLoadedClass(name);
            }

            @Override
            public byte[] upToFrames(String className) throws ClassNotFoundException {
                return TransformingClassLoader.this.buildTransformedClassNodeFor(className, ClassProcessorIds.COMPUTING_FRAMES);
            }

            @Override
            public Class<?> locateParentClass(String className) throws ClassNotFoundException {
                return Class.forName(className, false, TransformingClassLoader.this.getParent());
            }
        });
    }

    private Class<?> getLoadedClass(String name) {
        return this.findLoadedClass(name);
    }

    byte[] buildTransformedClassNodeFor(String className, ProcessorName upToTransformer) throws ClassNotFoundException {
        return super.getMaybeTransformedClassBytes(className, upToTransformer.toString());
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

