/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.i18n;

import java.nio.file.Path;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.neoforged.fml.Logging;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.i18n.I18nManager;
import net.neoforged.fml.i18n.MavenVersionTranslator;
import net.neoforged.fml.loading.StringUtils;
import net.neoforged.fml.util.PathPrettyPrinting;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.ForgeFeature;
import net.neoforged.neoforgespi.locating.IModFile;
import org.apache.commons.lang3.text.ExtendedMessageFormat;
import org.apache.commons.lang3.text.FormatFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.VersionRange;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FMLTranslations {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, FormatFactory> CUSTOM_FACTORIES;
    private static final Pattern PATTERN_CONTROL_CODE;
    private static final Pattern FORMAT_PATTERN;

    public static String getPattern(String patternName, Supplier<String> fallback) {
        String translated = I18nManager.currentLocale.get(patternName);
        return translated == null ? fallback.get() : translated;
    }

    public static String parseMessage(String i18nMessage, Object ... args) {
        return FMLTranslations.parseMessageWithFallback(i18nMessage, () -> i18nMessage, args);
    }

    public static String parseMessageWithFallback(String i18nMessage, Supplier<String> fallback, Object ... args) {
        String pattern = FMLTranslations.getPattern(i18nMessage, fallback);
        try {
            return FMLTranslations.parseFormat(pattern, args);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(Logging.CORE, "Illegal format found `{}`", (Object)pattern);
            return pattern;
        }
    }

    public static String parseEnglishMessage(String i18n, Object ... args) {
        String translated = I18nManager.DEFAULT_TRANSLATIONS.getOrDefault(i18n, i18n);
        try {
            return FMLTranslations.parseFormat(translated, args);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(Logging.CORE, "Illegal format found `{}`", (Object)translated);
            return translated;
        }
    }

    public static String parseFormat(String format, Object ... args) {
        AtomicInteger i = new AtomicInteger();
        format = FORMAT_PATTERN.matcher(format).replaceAll(matchResult -> {
            if (matchResult.group(0).equals("%%")) {
                return "%";
            }
            String groupIdx = matchResult.group(1);
            int index = groupIdx != null ? Integer.parseInt(groupIdx) - 1 : i.getAndIncrement();
            return "{" + index + "}";
        });
        ExtendedMessageFormat extendedMessageFormat = new ExtendedMessageFormat(format, CUSTOM_FACTORIES);
        return extendedMessageFormat.format((Object)args);
    }

    public static String translateIssueEnglish(ModLoadingIssue issue) {
        Object[] args = FMLTranslations.getTranslationArgs(issue);
        return FMLTranslations.parseEnglishMessage(issue.translationKey(), args);
    }

    public static String translateIssue(ModLoadingIssue issue) {
        Object[] args = FMLTranslations.getTranslationArgs(issue);
        return FMLTranslations.parseMessage(issue.translationKey(), args);
    }

    private static Object[] getTranslationArgs(ModLoadingIssue issue) {
        ArrayList<Object> args = new ArrayList<Object>(103);
        args.addAll(issue.translationArgs());
        while (args.size() < 100) {
            args.add(null);
        }
        args.add(FMLTranslations.getModInfo(issue));
        args.add(FMLTranslations.getAffectedPath(issue));
        args.add(issue.cause());
        args.replaceAll(FMLTranslations::formatArg);
        return args.toArray(Object[]::new);
    }

    @Nullable
    private static IModInfo getModInfo(ModLoadingIssue issue) {
        IModInfo modInfo = issue.affectedMod();
        IModFile file = issue.affectedModFile();
        while (modInfo == null && file != null) {
            if (!file.getModInfos().isEmpty()) {
                modInfo = file.getModInfos().getFirst();
            }
            file = file.getDiscoveryAttributes().parent();
        }
        return modInfo;
    }

    @Nullable
    private static Path getAffectedPath(ModLoadingIssue issue) {
        if (issue.affectedPath() != null) {
            return issue.affectedPath();
        }
        if (issue.affectedModFile() != null) {
            return issue.affectedModFile().getFilePath();
        }
        return null;
    }

    private static Object formatArg(Object arg) {
        if (arg instanceof IModFile) {
            IModFile modFile = (IModFile)arg;
            return PathPrettyPrinting.prettyPrint(modFile.getFilePath());
        }
        if (arg instanceof Path) {
            Path path = (Path)arg;
            return PathPrettyPrinting.prettyPrint(path);
        }
        return arg;
    }

    public static String stripControlCodes(String text) {
        return PATTERN_CONTROL_CODE.matcher(text).replaceAll("");
    }

    private static void formatException(StringBuffer stringBuffer, Throwable t, String args) {
        if (Objects.equals(args, "msg")) {
            stringBuffer.append(t.getClass().getName()).append(": ").append(t.getMessage());
        } else if (Objects.equals(args, "cls")) {
            stringBuffer.append(t.getClass().getName());
        }
    }

    private static void formatModInfo(StringBuffer stringBuffer, IModInfo info, String args) {
        if (Objects.equals(args, "id")) {
            stringBuffer.append(info.getModId());
        } else if (Objects.equals(args, "name")) {
            stringBuffer.append(info.getDisplayName());
        } else {
            LOGGER.warn("Cannot format unknown mod info property in translation: {}", (Object)args);
        }
    }

    private static void formatVersionRange(StringBuffer stringBuffer, VersionRange range) {
        stringBuffer.append(MavenVersionTranslator.versionRangeToString(range));
    }

    private static void formatFeatureBoundValue(StringBuffer stringBuffer, ForgeFeature.Bound bound) {
        stringBuffer.append(bound.featureName());
        Object t = bound.bound();
        if (t instanceof Boolean) {
            Boolean b = (Boolean)t;
            stringBuffer.append("=").append(b);
        } else {
            t = bound.bound();
            if (t instanceof VersionRange) {
                VersionRange vr = (VersionRange)t;
                stringBuffer.append(" ").append(MavenVersionTranslator.versionRangeToString(vr));
            } else {
                stringBuffer.append("=\"").append(bound.featureBound()).append("\"");
            }
        }
    }

    private static void formatOrNull(StringBuffer stringBuffer, Object o, String args) {
        stringBuffer.append(Objects.equals(String.valueOf(o), "null") ? FMLTranslations.parseMessage(args, new Object[0]) : String.valueOf(o));
    }

    private static void formatOptional(StringBuffer stringBuffer, Optional<?> value, String args) {
        args = Objects.requireNonNullElse(args, "");
        if (value.isPresent()) {
            stringBuffer.append(args).append(value.get());
        }
    }

    static {
        PATTERN_CONTROL_CODE = Pattern.compile("(?i)\\u00A7[0-9A-FK-OR]");
        FORMAT_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");
        CUSTOM_FACTORIES = new HashMap<String, FormatFactory>();
        CUSTOM_FACTORIES.put("modinfo", new CustomFormat<IModInfo>(IModInfo.class, FMLTranslations::formatModInfo));
        CUSTOM_FACTORIES.put("lower", new CustomFormat<Object>(Object.class, (stringBuffer, value) -> stringBuffer.append(StringUtils.toLowerCase(String.valueOf(value)))));
        CUSTOM_FACTORIES.put("upper", new CustomFormat<Object>(Object.class, (stringBuffer, value) -> stringBuffer.append(StringUtils.toUpperCase(String.valueOf(value)))));
        CUSTOM_FACTORIES.put("exc", new CustomFormat<Throwable>(Throwable.class, FMLTranslations::formatException));
        CUSTOM_FACTORIES.put("vr", new CustomFormat<VersionRange>(VersionRange.class, FMLTranslations::formatVersionRange));
        CUSTOM_FACTORIES.put("featurebound", new CustomFormat<ForgeFeature.Bound>(ForgeFeature.Bound.class, FMLTranslations::formatFeatureBoundValue));
        CUSTOM_FACTORIES.put("i18n", new CustomFormat<Object>(Object.class, (stringBuffer, o, args) -> stringBuffer.append(FMLTranslations.parseMessage(args, o))));
        CUSTOM_FACTORIES.put("i18ntranslate", new CustomFormat<String>(String.class, (stringBuffer, o) -> stringBuffer.append(FMLTranslations.parseMessage(o, new Object[0]))));
        CUSTOM_FACTORIES.put("ornull", new CustomFormat<Object>(Object.class, FMLTranslations::formatOrNull));
        CUSTOM_FACTORIES.put("optional", new CustomFormat<Optional>(Optional.class, FMLTranslations::formatOptional));
    }

    private record CustomFormat<T>(Class<T> valueClass, FormatFunctionWithArgs<T> formatter) implements FormatFactory
    {
        public CustomFormat(Class<T> valueClass, FormatFunction<T> formatter) {
            this(valueClass, (StringBuffer toAppendTo, T value, String args) -> formatter.format(toAppendTo, value));
        }

        public Format getFormat(final String name, final String arguments, Locale locale) {
            return new Format(){

                @Override
                public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
                    if (valueClass.isInstance(obj)) {
                        formatter.format(toAppendTo, valueClass.cast(obj), arguments);
                    } else if (obj != null) {
                        LOGGER.warn("Translation format {} expected type {}, but got: {}", (Object)name, valueClass, obj.getClass());
                    }
                    return toAppendTo;
                }

                @Override
                public Object parseObject(String source, ParsePosition pos) {
                    throw new UnsupportedOperationException("Parsing is not supported");
                }
            };
        }

        @FunctionalInterface
        static interface FormatFunctionWithArgs<T> {
            public void format(StringBuffer var1, T var2, String var3);
        }

        @FunctionalInterface
        static interface FormatFunction<T> {
            public void format(StringBuffer var1, T var2);
        }
    }
}

