/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.jarcontents;

final class PathNormalization {
    private static final char SEPARATOR = '/';

    private PathNormalization() {
    }

    public static void assertNormalized(CharSequence path) {
        if (!PathNormalization.isNormalized(path)) {
            throw new IllegalArgumentException("Path is not a valid relative path: " + String.valueOf(path));
        }
    }

    public static boolean isNormalized(CharSequence path) {
        if (path.isEmpty()) {
            return true;
        }
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '\\') continue;
            return false;
        }
        int prevCh = 0;
        int segmentStart = 0;
        for (int i = 0; i < path.length(); ++i) {
            boolean atEnd = i == path.length() - 1;
            char ch = path.charAt(i);
            if ((i == 0 || atEnd) && ch == '/') {
                return false;
            }
            if (ch == '/' && prevCh == 47) {
                return false;
            }
            if (ch == '/' || atEnd) {
                int segmentEnd = ch == '/' ? i - 1 : i;
                int segmentLength = segmentEnd - segmentStart + 1;
                if (segmentLength == 1 && path.charAt(segmentStart) == '.') {
                    return false;
                }
                if (segmentLength == 2 && path.charAt(segmentStart) == '.' && path.charAt(segmentEnd) == '.') {
                    return false;
                }
                segmentStart = i + 1;
            }
            prevCh = ch;
        }
        return true;
    }

    public static String normalize(CharSequence path) {
        return PathNormalization.normalize(path, false);
    }

    public static String normalizeFolderPrefix(CharSequence path) {
        return PathNormalization.normalize(path, true);
    }

    private static String normalize(CharSequence path, boolean folderPrefix) {
        StringBuilder result = new StringBuilder(path.length());
        int startOfSegment = 0;
        for (int i = 0; i < path.length(); ++i) {
            int ch = path.charAt(i);
            if (ch == 92) {
                ch = 47;
            }
            if (ch != 47) continue;
            if (i > startOfSegment) {
                if (!result.isEmpty()) {
                    result.append('/');
                }
                CharSequence segment = path.subSequence(startOfSegment, i);
                PathNormalization.validateSegment(segment);
                result.append(segment);
            }
            startOfSegment = i + 1;
        }
        if (startOfSegment < path.length()) {
            if (!result.isEmpty()) {
                result.append('/');
            }
            CharSequence segment = path.subSequence(startOfSegment, path.length());
            PathNormalization.validateSegment(segment);
            result.append(segment);
        }
        if (folderPrefix && !result.isEmpty()) {
            result.append('/');
        }
        return result.toString();
    }

    private static void validateSegment(CharSequence segment) {
        if (segment.equals(".") || segment.equals("..")) {
            throw new IllegalArgumentException("./ or ../ segments in paths are not supported");
        }
    }
}

