/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.fml.loading.moddiscovery.ModInfo;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadingModList {
    private static final Logger LOG = LoggerFactory.getLogger(LoadingModList.class);
    private final List<IModFileInfo> plugins;
    private final List<IModFile> gameLibraries;
    private final List<ModFileInfo> modFiles;
    private final List<ModInfo> sortedList;
    private final Map<ModInfo, List<ModInfo>> modDependencies;
    private final Map<String, ModFileInfo> fileById;
    @Nullable
    private volatile Map<String, IModFile> fileByPackage;
    private final List<ModLoadingIssue> modLoadingIssues;
    private final Set<IModFile> allModFiles = Collections.newSetFromMap(new IdentityHashMap());

    private LoadingModList(List<ModFile> plugins, List<ModFile> gameLibraries, List<ModFile> modFiles, List<ModInfo> sortedList, Map<ModInfo, List<ModInfo>> modDependencies) {
        this.plugins = plugins.stream().map(ModFile::getModFileInfo).collect(Collectors.toList());
        this.gameLibraries = List.copyOf(gameLibraries);
        this.modFiles = modFiles.stream().map(ModFile::getModFileInfo).map(ModFileInfo.class::cast).collect(Collectors.toList());
        this.sortedList = new ArrayList<ModInfo>(sortedList);
        this.modDependencies = modDependencies;
        this.fileById = this.modFiles.stream().map(ModFileInfo::getMods).flatMap(Collection::stream).map(ModInfo.class::cast).collect(Collectors.toMap(ModInfo::getModId, ModInfo::getOwningFile));
        this.modLoadingIssues = new ArrayList<ModLoadingIssue>();
        this.allModFiles.addAll(this.gameLibraries);
        this.allModFiles.addAll(modFiles);
        this.allModFiles.addAll(plugins);
    }

    public static LoadingModList of(List<ModFile> plugins, List<ModFile> gameLibraries, List<ModFile> modFiles, List<ModInfo> sortedList, List<ModLoadingIssue> issues, Map<ModInfo, List<ModInfo>> modDependencies) {
        LoadingModList list = new LoadingModList(plugins, gameLibraries, modFiles, sortedList, modDependencies);
        list.modLoadingIssues.addAll(issues);
        return list;
    }

    @Deprecated(forRemoval=true)
    public static LoadingModList get() {
        return FMLLoader.getCurrent().getLoadingModList();
    }

    public boolean contains(IModFile modFile) {
        return this.allModFiles.contains(modFile);
    }

    public List<IModFileInfo> getPlugins() {
        return this.plugins;
    }

    public List<IModFile> getGameLibraries() {
        return this.gameLibraries;
    }

    public List<ModFileInfo> getModFiles() {
        return this.modFiles;
    }

    public Set<IModFile> getAllModFiles() {
        return this.allModFiles;
    }

    public ModFileInfo getModFileById(String modid) {
        return this.fileById.get(modid);
    }

    public List<ModInfo> getMods() {
        return this.sortedList;
    }

    public List<ModInfo> getDependencies(IModInfo mod) {
        return this.modDependencies.getOrDefault(mod, List.of());
    }

    public boolean hasErrors() {
        return !this.modLoadingIssues.isEmpty() && this.modLoadingIssues.stream().anyMatch(issue -> issue.severity() == ModLoadingIssue.Severity.ERROR);
    }

    public List<ModLoadingIssue> getModLoadingIssues() {
        return this.modLoadingIssues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, IModFile> getPackageIndex() {
        Map<String, IModFile> fileByPackage = this.fileByPackage;
        if (fileByPackage == null) {
            LoadingModList loadingModList = this;
            synchronized (loadingModList) {
                if (this.fileByPackage == null) {
                    this.fileByPackage = this.buildPackageIndex();
                }
                fileByPackage = this.fileByPackage;
            }
        }
        return fileByPackage;
    }

    private Map<String, IModFile> buildPackageIndex() {
        long start = System.nanoTime();
        Map<String, IModFile> result = new HashMap();
        for (IModFile modFile : this.allModFiles) {
            for (String packageName : ((ModFile)modFile).getModuleDescriptor().packages()) {
                result.put(packageName, modFile);
            }
        }
        result = Map.copyOf(result);
        long elapsed = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        LOG.debug("Built package index ({} entries) in {}ms", (Object)result.size(), (Object)elapsed);
        return result;
    }
}

