/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.mixin;

import java.util.Set;
import net.neoforged.fml.loading.mixin.FMLAuditTrail;
import net.neoforged.fml.loading.mixin.FMLClassBytecodeProvider;
import net.neoforged.fml.loading.mixin.FMLClassTracker;
import net.neoforged.fml.loading.mixin.FMLMixinService;
import net.neoforged.neoforgespi.transformation.ClassProcessor;
import net.neoforged.neoforgespi.transformation.ClassProcessorIds;
import net.neoforged.neoforgespi.transformation.ProcessorName;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.IMixinTransformer;
import org.spongepowered.asm.service.ISyntheticClassRegistry;

public class FMLMixinClassProcessor
implements ClassProcessor {
    private final FMLAuditTrail auditTrail;
    private final FMLClassTracker classTracker;
    private final IMixinTransformer transformer;
    private final ISyntheticClassRegistry registry;
    private final FMLMixinService service;

    public FMLMixinClassProcessor(FMLMixinService service) {
        this.auditTrail = service.getInternalAuditTrail();
        this.classTracker = service.getInternalClassTracker();
        this.transformer = service.getMixinTransformer();
        this.registry = this.transformer.getExtensions().getSyntheticClassRegistry();
        this.service = service;
    }

    @Override
    public void link(ClassProcessor.LinkContext context) {
        this.service.setBytecodeProvider(new FMLClassBytecodeProvider(context.bytecodeProvider(), this));
    }

    @Override
    public ProcessorName name() {
        return ClassProcessorIds.MIXIN;
    }

    @Override
    public Set<String> generatesPackages() {
        return Set.of("org.spongepowered.asm.synthetic.args");
    }

    @Override
    public boolean handlesClass(ClassProcessor.SelectionContext context) {
        String name = context.type().getClassName();
        if (this.classTracker.isInvalidClass(name)) {
            throw new NoClassDefFoundError(String.format("%s is invalid", name));
        }
        if (!context.empty() && this.processesClass(context.type())) {
            return true;
        }
        if (this.transformer.getExtensions().getSyntheticClassRegistry() == null) {
            return false;
        }
        return this.generatesClass(context.type());
    }

    private boolean processesClass(Type classType) {
        MixinEnvironment environment = MixinEnvironment.getCurrentEnvironment();
        return this.transformer.couldTransformClass(environment, classType.getClassName());
    }

    boolean generatesClass(Type classType) {
        return this.registry.findSyntheticClass(classType.getClassName()) != null;
    }

    boolean generateClass(Type classType, ClassNode classNode) {
        return this.transformer.generateClass(MixinEnvironment.getCurrentEnvironment(), classType.getClassName(), classNode);
    }

    @Override
    public ClassProcessor.ComputeFlags processClass(ClassProcessor.TransformationContext context) {
        Type classType = context.type();
        ClassNode classNode = context.node();
        this.auditTrail.setConsumer(classType.getClassName(), context::audit);
        if (this.generatesClass(classType)) {
            return this.generateClass(classType, classNode) ? ClassProcessor.ComputeFlags.COMPUTE_FRAMES : ClassProcessor.ComputeFlags.NO_REWRITE;
        }
        MixinEnvironment environment = MixinEnvironment.getCurrentEnvironment();
        return this.transformer.transformClass(environment, classType.getClassName(), classNode) ? ClassProcessor.ComputeFlags.COMPUTE_FRAMES : ClassProcessor.ComputeFlags.NO_REWRITE;
    }

    @Override
    public void afterProcessing(ClassProcessor.AfterProcessingContext context) {
        this.classTracker.addLoadedClass(context.type().getClassName());
    }
}

