/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforgespi.locating;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.jarmoduleinfo.JarModuleInfo;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import net.neoforged.neoforgespi.locating.InvalidModFileException;
import net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes;
import net.neoforged.neoforgespi.locating.ModFileInfoParser;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface IModFile {
    public static IModFile create(JarContents contents, ModFileInfoParser parser) throws InvalidModFileException {
        return new ModFile(contents, parser, ModFileDiscoveryAttributes.DEFAULT);
    }

    public static IModFile create(JarContents contents, JarModuleInfo metadata, ModFileInfoParser parser) throws InvalidModFileException {
        return new ModFile(contents, metadata, parser, ModFileDiscoveryAttributes.DEFAULT);
    }

    public static IModFile create(JarContents contents, ModFileInfoParser parser, ModFileDiscoveryAttributes attributes) throws InvalidModFileException {
        return new ModFile(contents, parser, attributes);
    }

    public static IModFile create(JarContents contents, JarModuleInfo metadata, ModFileInfoParser parser, Type type, ModFileDiscoveryAttributes attributes) throws InvalidModFileException {
        return new ModFile(contents, metadata, parser, type, attributes);
    }

    public static IModFile create(JarContents contents, ModFileInfoParser parser, Type type, ModFileDiscoveryAttributes attributes) throws InvalidModFileException {
        return new ModFile(contents, null, parser, type, attributes);
    }

    public String getId();

    public JarContents getContents();

    public Supplier<Map<String, Object>> getSubstitutionMap();

    public Type getType();

    public Path getFilePath();

    public List<IModInfo> getModInfos();

    public ModFileScanData getScanResult();

    public String getFileName();

    public ModFileDiscoveryAttributes getDiscoveryAttributes();

    public IModFileInfo getModFileInfo();

    public static enum Type {
        MOD,
        LIBRARY,
        GAMELIBRARY;

    }
}

