/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.neoforged.fml.Bindings;
import net.neoforged.fml.ModLoadingStage;
import net.neoforged.fml.loading.EarlyLoadingException;
import net.neoforged.neoforgespi.language.IModInfo;

public class ModLoadingException
extends RuntimeException {
    private static final long serialVersionUID = 2048947398536935507L;
    private final IModInfo modInfo;
    private final ModLoadingStage errorStage;
    private final String i18nMessage;
    private final List<Object> context;

    public ModLoadingException(IModInfo modInfo, ModLoadingStage errorStage, String i18nMessage, Throwable originalException, Object ... context) {
        super("Mod Loading Exception", originalException);
        this.modInfo = modInfo;
        this.errorStage = errorStage;
        this.i18nMessage = i18nMessage;
        this.context = Arrays.asList(context);
    }

    static Stream<ModLoadingException> fromEarlyException(EarlyLoadingException e) {
        return e.getAllData().stream().map(ed -> new ModLoadingException(ed.getModInfo(), ModLoadingStage.VALIDATE, ed.getI18message(), e.getCause(), ed.getArgs()));
    }

    public String getI18NMessage() {
        return this.i18nMessage;
    }

    public Object[] getContext() {
        return this.context.toArray();
    }

    public String formatToString() {
        return Bindings.getMessageParser().get().parseMessage(this.i18nMessage, Streams.concat((Stream[])new Stream[]{Stream.of(new Object[]{this.modInfo, this.errorStage, this.getCause()}), this.context.stream()}).toArray());
    }

    @Override
    public String getMessage() {
        return this.formatToString();
    }

    public IModInfo getModInfo() {
        return this.modInfo;
    }

    public String getCleanMessage() {
        return Bindings.getMessageParser().get().stripControlCodes(this.formatToString());
    }
}

