/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.IModLoadingState;
import net.neoforged.fml.IModStateTransition;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingPhase;
import net.neoforged.fml.loading.progress.ProgressMeter;

public record ModLoadingState(String name, String previous, Function<ModList, String> message, ToIntFunction<ModList> size, ModLoadingPhase phase, Optional<Consumer<ModList>> inlineRunnable, Optional<IModStateTransition> transition) implements IModLoadingState
{
    @Override
    public <T extends Event> Optional<CompletableFuture<Void>> buildTransition(Executor syncExecutor, Executor parallelExecutor, ProgressMeter progressBar, Function<Executor, CompletableFuture<Void>> preSyncTask, Function<Executor, CompletableFuture<Void>> postSyncTask) {
        return this.transition.map(t -> t.build(this.name, syncExecutor, parallelExecutor, progressBar, preSyncTask, postSyncTask));
    }

    public static ModLoadingState empty(String name, String previous, ModLoadingPhase phase) {
        return new ModLoadingState(name, previous, ml -> "", f -> 0, phase, Optional.empty(), Optional.empty());
    }

    public static ModLoadingState withTransition(String name, String previous, ModLoadingPhase phase, IModStateTransition transition) {
        return new ModLoadingState(name, previous, ml -> "Processing transition " + name, ModList::size, phase, Optional.empty(), Optional.of(transition));
    }

    public static ModLoadingState withTransition(String name, String previous, Function<ModList, String> message, ModLoadingPhase phase, IModStateTransition transition) {
        return new ModLoadingState(name, previous, message, ModList::size, phase, Optional.empty(), Optional.of(transition));
    }

    public static ModLoadingState withInline(String name, String previous, ModLoadingPhase phase, Consumer<ModList> inline) {
        return new ModLoadingState(name, previous, ml -> "Processing work " + name, ml -> 0, phase, Optional.of(inline), Optional.empty());
    }
}

