/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.mojang.logging.LogUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.neoforged.fml.config.ConfigFileTypeHandler;
import net.neoforged.fml.config.IConfigEvent;
import net.neoforged.fml.config.ModConfig;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ConfigTracker {
    private static final Logger LOGGER = LogUtils.getLogger();
    static final Marker CONFIG = MarkerFactory.getMarker((String)"CONFIG");
    public static final ConfigTracker INSTANCE = new ConfigTracker();
    private final ConcurrentHashMap<String, ModConfig> fileMap = new ConcurrentHashMap();
    private final EnumMap<ModConfig.Type, Set<ModConfig>> configSets = new EnumMap(ModConfig.Type.class);
    private final ConcurrentHashMap<String, Map<ModConfig.Type, ModConfig>> configsByMod = new ConcurrentHashMap();

    private ConfigTracker() {
        this.configSets.put(ModConfig.Type.CLIENT, Collections.synchronizedSet(new LinkedHashSet()));
        this.configSets.put(ModConfig.Type.COMMON, Collections.synchronizedSet(new LinkedHashSet()));
        this.configSets.put(ModConfig.Type.SERVER, Collections.synchronizedSet(new LinkedHashSet()));
    }

    void trackConfig(ModConfig config) {
        if (this.fileMap.containsKey(config.getFileName())) {
            LOGGER.error(CONFIG, "Detected config file conflict {} between {} and {}", new Object[]{config.getFileName(), this.fileMap.get(config.getFileName()).getModId(), config.getModId()});
            throw new RuntimeException("Config conflict detected!");
        }
        this.fileMap.put(config.getFileName(), config);
        this.configSets.get((Object)config.getType()).add(config);
        this.configsByMod.computeIfAbsent(config.getModId(), k -> new EnumMap(ModConfig.Type.class)).put(config.getType(), config);
        LOGGER.debug(CONFIG, "Config file {} for {} tracking", (Object)config.getFileName(), (Object)config.getModId());
    }

    public void loadConfigs(ModConfig.Type type, Path configBasePath) {
        this.loadConfigs(type, configBasePath, null);
    }

    public void loadConfigs(ModConfig.Type type, Path configBasePath, @Nullable Path configOverrideBasePath) {
        LOGGER.debug(CONFIG, "Loading configs type {}", (Object)type);
        this.configSets.get((Object)type).forEach(config -> this.openConfig((ModConfig)config, configBasePath, configOverrideBasePath));
    }

    public void unloadConfigs(ModConfig.Type type) {
        LOGGER.debug(CONFIG, "Unloading configs type {}", (Object)type);
        this.configSets.get((Object)type).forEach(this::closeConfig);
    }

    private Path resolveBasePath(ModConfig config, Path configBasePath, @Nullable Path configOverrideBasePath) {
        Path overrideFilePath;
        if (configOverrideBasePath != null && Files.exists(overrideFilePath = configOverrideBasePath.resolve(config.getFileName()), new LinkOption[0])) {
            LOGGER.info(CONFIG, "Found config file override in path {}", (Object)overrideFilePath);
            return configOverrideBasePath;
        }
        return configBasePath;
    }

    private void openConfig(ModConfig config, Path configBasePath, @Nullable Path configOverrideBasePath) {
        LOGGER.trace(CONFIG, "Loading config file type {} at {} for {}", new Object[]{config.getType(), config.getFileName(), config.getModId()});
        Path basePath = this.resolveBasePath(config, configBasePath, configOverrideBasePath);
        CommentedFileConfig configData = ConfigFileTypeHandler.TOML.reader(basePath).apply(config);
        config.setConfigData((CommentedConfig)configData);
        IConfigEvent.loading(config).post();
        config.save();
    }

    private void closeConfig(ModConfig config) {
        if (config.getConfigData() != null) {
            LOGGER.trace(CONFIG, "Closing config file type {} at {} for {}", new Object[]{config.getType(), config.getFileName(), config.getModId()});
            ConfigFileTypeHandler.TOML.unload(config);
            IConfigEvent unloading = IConfigEvent.unloading(config);
            if (unloading != null) {
                unloading.post();
            }
            config.save();
            config.setConfigData(null);
        }
    }

    public void loadDefaultServerConfigs() {
        this.configSets.get((Object)ModConfig.Type.SERVER).forEach(modConfig -> {
            CommentedConfig commentedConfig = CommentedConfig.inMemory();
            modConfig.getSpec().correct(commentedConfig);
            modConfig.setConfigData(commentedConfig);
            IConfigEvent.loading(modConfig).post();
        });
    }

    public String getConfigFileName(String modId, ModConfig.Type type) {
        return Optional.ofNullable(this.configsByMod.getOrDefault(modId, Collections.emptyMap()).getOrDefault((Object)type, null)).map(ModConfig::getFullPath).map(Object::toString).orElse(null);
    }

    public Map<ModConfig.Type, Set<ModConfig>> configSets() {
        return this.configSets;
    }

    public ConcurrentHashMap<String, ModConfig> fileMap() {
        return this.fileMap;
    }
}

