/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.event.lifecycle;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.neoforged.fml.DeferredWorkQueue;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingStage;
import net.neoforged.fml.event.lifecycle.ModLifecycleEvent;

public abstract class ParallelDispatchEvent
extends ModLifecycleEvent {
    private final ModLoadingStage modLoadingStage;

    public ParallelDispatchEvent(ModContainer container, ModLoadingStage stage) {
        super(container);
        this.modLoadingStage = stage;
    }

    private Optional<DeferredWorkQueue> getQueue() {
        return DeferredWorkQueue.lookup(Optional.of(this.modLoadingStage));
    }

    public CompletableFuture<Void> enqueueWork(Runnable work) {
        return this.getQueue().map(q -> q.enqueueWork(this.getContainer(), work)).orElseThrow(() -> new RuntimeException("No work queue found!"));
    }

    public <T> CompletableFuture<T> enqueueWork(Supplier<T> work) {
        return this.getQueue().map(q -> q.enqueueWork(this.getContainer(), work)).orElseThrow(() -> new RuntimeException("No work queue found!"));
    }
}

