/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.javafmlmod;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.Bindings;
import net.neoforged.fml.Logging;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.moddiscovery.ModAnnotation;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class AutomaticEventSubscriber {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Type AUTO_SUBSCRIBER = Type.getType(Mod.EventBusSubscriber.class);
    private static final Type MOD_TYPE = Type.getType(Mod.class);

    public static void inject(ModContainer mod, ModFileScanData scanData, ClassLoader loader) {
        if (scanData == null) {
            return;
        }
        LOGGER.debug(Logging.LOADING, "Attempting to inject @EventBusSubscriber classes into the eventbus for {}", (Object)mod.getModId());
        List<ModFileScanData.AnnotationData> ebsTargets = scanData.getAnnotations().stream().filter(annotationData -> AUTO_SUBSCRIBER.equals((Object)annotationData.annotationType())).collect(Collectors.toList());
        Map<String, String> modids = scanData.getAnnotations().stream().filter(annotationData -> MOD_TYPE.equals((Object)annotationData.annotationType())).collect(Collectors.toMap(a -> a.clazz().getClassName(), a -> (String)a.annotationData().get("value")));
        ebsTargets.forEach(ad -> {
            List<ModAnnotation.EnumHolder> sidesValue = ad.annotationData().getOrDefault("value", Arrays.asList(new ModAnnotation.EnumHolder(null, "CLIENT"), new ModAnnotation.EnumHolder(null, "DEDICATED_SERVER")));
            EnumSet sides = sidesValue.stream().map(eh -> Dist.valueOf((String)eh.getValue())).collect(Collectors.toCollection(() -> EnumSet.noneOf(Dist.class)));
            String modId = ad.annotationData().getOrDefault("modid", modids.getOrDefault(ad.clazz().getClassName(), mod.getModId()));
            ModAnnotation.EnumHolder busTargetHolder = ad.annotationData().getOrDefault("bus", new ModAnnotation.EnumHolder(null, "FORGE"));
            Mod.EventBusSubscriber.Bus busTarget = Mod.EventBusSubscriber.Bus.valueOf(busTargetHolder.getValue());
            if (Objects.equals(mod.getModId(), modId) && sides.contains(FMLEnvironment.dist)) {
                try {
                    IEventBus bus;
                    switch (busTarget) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case FORGE: {
                            IEventBus iEventBus = Bindings.getForgeBus().get();
                            break;
                        }
                        case MOD: {
                            IEventBus iEventBus = bus = mod.getEventBus();
                        }
                    }
                    if (bus != null) {
                        LOGGER.debug(Logging.LOADING, "Auto-subscribing {} to {}", (Object)ad.clazz().getClassName(), (Object)busTarget);
                        bus.register(Class.forName(ad.clazz().getClassName(), true, loader));
                    }
                }
                catch (ClassNotFoundException e) {
                    LOGGER.fatal(Logging.LOADING, "Failed to load mod class {} for @EventBusSubscriber annotation", (Object)ad.clazz(), (Object)e);
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

