/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.neoforged.fml.loading.FMLConfig;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.progress.ProgressMeter;
import net.neoforged.fml.loading.progress.StartupNotificationManager;
import net.neoforged.neoforgespi.earlywindow.GraphicsBootstrapper;
import net.neoforged.neoforgespi.earlywindow.ImmediateWindowProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ImmediateWindowHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static ImmediateWindowProvider provider;
    private static ProgressMeter earlyProgress;

    public static void load(String launchTarget, String[] arguments) {
        ModuleLayer layer = (ModuleLayer)Launcher.INSTANCE.findLayerManager().flatMap(manager -> manager.getLayer(IModuleLayerManager.Layer.SERVICE)).orElseThrow(() -> new IllegalStateException("Couldn't find SERVICE layer"));
        ServiceLoader.load(layer, GraphicsBootstrapper.class).stream().map(ServiceLoader.Provider::get).forEach(bootstrap -> {
            LOGGER.debug("Invoking bootstrap method {}", (Object)bootstrap.name());
            bootstrap.bootstrap(arguments);
        });
        if (!List.of("forgeclient", "forgeclientuserdev", "forgeclientdev").contains(launchTarget)) {
            provider = new DummyProvider();
            LOGGER.info("ImmediateWindowProvider not loading because launch target is {}", (Object)launchTarget);
        } else if (!FMLConfig.getBoolConfigValue(FMLConfig.ConfigValue.EARLY_WINDOW_CONTROL)) {
            provider = new DummyProvider();
            LOGGER.info("ImmediateWindowProvider not loading because splash screen is disabled");
        } else {
            String providername = FMLConfig.getConfigValue(FMLConfig.ConfigValue.EARLY_WINDOW_PROVIDER);
            LOGGER.info("Loading ImmediateWindowProvider {}", (Object)providername);
            Optional<ImmediateWindowProvider> maybeProvider = ServiceLoader.load(layer, ImmediateWindowProvider.class).stream().map(ServiceLoader.Provider::get).filter(p -> Objects.equals(p.name(), providername)).findFirst();
            provider = maybeProvider.or(() -> {
                LOGGER.info("Failed to find ImmediateWindowProvider {}, disabling", (Object)providername);
                return Optional.of(new DummyProvider());
            }).orElseThrow();
        }
        if (!Objects.equals(provider.name(), "dummyprovider")) {
            FMLConfig.updateConfig(FMLConfig.ConfigValue.EARLY_WINDOW_PROVIDER, provider.name());
        }
        FMLLoader.progressWindowTick = provider.initialize(arguments);
        earlyProgress = StartupNotificationManager.addProgressBar("EARLY", 0);
        earlyProgress.label("Bootstrapping Minecraft");
    }

    public static long setupMinecraftWindow(IntSupplier width, IntSupplier height, Supplier<String> title, LongSupplier monitor) {
        return provider.setupMinecraftWindow(width, height, title, monitor);
    }

    public static boolean positionWindow(Optional<Object> monitor, IntConsumer widthSetter, IntConsumer heightSetter, IntConsumer xSetter, IntConsumer ySetter) {
        return provider.positionWindow(monitor, widthSetter, heightSetter, xSetter, ySetter);
    }

    public static void updateFBSize(IntConsumer width, IntConsumer height) {
        provider.updateFramebufferSize(width, height);
    }

    public static <T> Supplier<T> loadingOverlay(Supplier<?> mc, Supplier<?> ri, Consumer<Optional<Throwable>> ex, boolean fade) {
        earlyProgress.complete();
        return provider.loadingOverlay(mc, ri, ex, fade);
    }

    public static void acceptGameLayer(ModuleLayer layer) {
        provider.updateModuleReads(layer);
    }

    public static void renderTick() {
        provider.periodicTick();
    }

    public static String getGLVersion() {
        return provider.getGLVersion();
    }

    public static void updateProgress(String message) {
        earlyProgress.label(message);
    }

    public static void crash(String message) {
        provider.crash(message);
    }

    private record DummyProvider() implements ImmediateWindowProvider
    {
        private static Method NV_HANDOFF;
        private static Method NV_POSITION;
        private static Method NV_OVERLAY;
        private static Method NV_VERSION;

        public String name() {
            return "dummyprovider";
        }

        public Runnable initialize(String[] args) {
            return () -> {};
        }

        public void updateFramebufferSize(IntConsumer width, IntConsumer height) {
        }

        public long setupMinecraftWindow(IntSupplier width, IntSupplier height, Supplier<String> title, LongSupplier monitor) {
            try {
                LongSupplier longsupplier = (LongSupplier)NV_HANDOFF.invoke(null, width, height, title, monitor);
                return longsupplier.getAsLong();
            }
            catch (Throwable e) {
                throw new IllegalStateException("How did you get here?", e);
            }
        }

        public boolean positionWindow(Optional<Object> monitor, IntConsumer widthSetter, IntConsumer heightSetter, IntConsumer xSetter, IntConsumer ySetter) {
            try {
                return (Boolean)NV_POSITION.invoke(null, monitor, widthSetter, heightSetter, xSetter, ySetter);
            }
            catch (Throwable e) {
                throw new IllegalStateException("How did you get here?", e);
            }
        }

        public <T> Supplier<T> loadingOverlay(Supplier<?> mc, Supplier<?> ri, Consumer<Optional<Throwable>> ex, boolean fade) {
            try {
                return (Supplier)NV_OVERLAY.invoke(null, mc, ri, ex, fade);
            }
            catch (Throwable e) {
                throw new IllegalStateException("How did you get here?", e);
            }
        }

        public String getGLVersion() {
            try {
                return (String)NV_VERSION.invoke(null, new Object[0]);
            }
            catch (Throwable e) {
                return "3.2";
            }
        }

        public void updateModuleReads(ModuleLayer layer) {
            Optional<Module> fm = layer.findModule("neoforge");
            if (fm.isPresent()) {
                this.getClass().getModule().addReads(fm.get());
                Class clz = fm.map(l -> Class.forName(l, "net.neoforged.neoforge.client.loading.NoVizFallback")).orElseThrow();
                Map methods = Arrays.stream(clz.getMethods()).filter(m -> Modifier.isStatic(m.getModifiers())).collect(Collectors.toMap(Method::getName, Function.identity()));
                NV_HANDOFF = (Method)methods.get("windowHandoff");
                NV_OVERLAY = (Method)methods.get("loadingOverlay");
                NV_POSITION = (Method)methods.get("windowPositioning");
                NV_VERSION = (Method)methods.get("glVersion");
            }
        }

        public void periodicTick() {
        }

        public void crash(String message) {
        }
    }
}

