/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.JarContentsBuilder;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.moddiscovery.ModFileParser;
import net.neoforged.fml.loading.moddiscovery.ModJarMetadata;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.IModLocator;
import net.neoforged.neoforgespi.locating.IModProvider;
import org.slf4j.Logger;

public class ExplodedDirectoryLocator
implements IModLocator {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<ExplodedMod> explodedMods = new ArrayList<ExplodedMod>();
    private final Map<ExplodedMod, IModFile> mods = new HashMap<ExplodedMod, IModFile>();

    public List<IModLocator.ModFileOrException> scanMods() {
        this.explodedMods.forEach(explodedMod -> {
            JarContents jarContents = new JarContentsBuilder().paths((Path[])explodedMod.paths().toArray(Path[]::new)).build();
            if (jarContents.findFile("META-INF/mods.toml").isPresent()) {
                ModJarMetadata mjm = new ModJarMetadata(jarContents);
                ModFile mf = new ModFile(SecureJar.from((JarContents)jarContents, (JarMetadata)mjm), (IModProvider)this, ModFileParser::modsTomlParser);
                mjm.setModFile(mf);
                this.mods.put((ExplodedMod)explodedMod, mf);
            } else {
                LOGGER.warn(LogMarkers.LOADING, "Failed to find exploded resource mods.toml in directory {}", (Object)explodedMod.paths().get(0).toString());
            }
        });
        return this.mods.values().stream().map(mf -> new IModLocator.ModFileOrException(mf, null)).toList();
    }

    public String name() {
        return "exploded directory";
    }

    public void scanFile(IModFile file, Consumer<Path> pathConsumer) {
        LOGGER.debug(LogMarkers.SCAN, "Scanning exploded directory {}", (Object)file.getFilePath().toString());
        try (Stream<Path> files = Files.find(file.getSecureJar().getRootPath(), Integer.MAX_VALUE, (p, a) -> p.getNameCount() > 0 && p.getFileName().toString().endsWith(".class"), new FileVisitOption[0]);){
            files.forEach(pathConsumer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOGGER.debug(LogMarkers.SCAN, "Exploded directory scan complete {}", (Object)file.getFilePath().toString());
    }

    public String toString() {
        return "{ExplodedDir locator}";
    }

    public void initArguments(Map<String, ?> arguments) {
        List explodedTargets = (List)arguments.get("explodedTargets");
        if (explodedTargets != null && !explodedTargets.isEmpty()) {
            this.explodedMods.addAll(explodedTargets);
        }
    }

    public boolean isValid(IModFile modFile) {
        return true;
    }

    public record ExplodedMod(String modid, List<Path> paths) {
    }
}

