/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.mojang.logging.LogUtils;
import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.JarContentsBuilder;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.moddiscovery.AbstractModProvider;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.fml.loading.moddiscovery.ModFileParser;
import net.neoforged.fml.loading.moddiscovery.ModJarMetadata;
import net.neoforged.fml.loading.moddiscovery.NightConfigWrapper;
import net.neoforged.fml.loading.targets.CommonLaunchHandler;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.IModLocator;
import net.neoforged.neoforgespi.locating.IModProvider;
import net.neoforged.neoforgespi.locating.ModFileFactory;
import org.slf4j.Logger;

public class MinecraftLocator
extends AbstractModProvider
implements IModLocator {
    private static final Logger LOGGER = LogUtils.getLogger();

    public List<IModLocator.ModFileOrException> scanMods() {
        CommonLaunchHandler launchHandler = FMLLoader.getLaunchHandler();
        CommonLaunchHandler.LocatedPaths baseMC = launchHandler.getMinecraftPaths();
        JarContents mcJarContents = new JarContentsBuilder().paths((Path[])baseMC.minecraftPaths().toArray(Path[]::new)).pathFilter(baseMC.minecraftFilter()).build();
        ModJarMetadata mcJarMetadata = new ModJarMetadata(mcJarContents);
        SecureJar mcSecureJar = SecureJar.from((JarContents)mcJarContents, (JarMetadata)mcJarMetadata);
        IModFile mcjar = ModFileFactory.FACTORY.build(mcSecureJar, (IModProvider)this, this::buildMinecraftTOML);
        mcJarMetadata.setModFile(mcjar);
        List artifacts = baseMC.otherArtifacts().stream().map(xva$0 -> SecureJar.from((Path[])new Path[]{xva$0})).map(sj -> new ModFile((SecureJar)sj, this, ModFileParser::modsTomlParser)).collect(Collectors.toList());
        Stream<IModLocator.ModFileOrException> othermods = baseMC.otherModPaths().stream().map(p -> this.createMod((Path[])p.toArray(Path[]::new))).filter(Objects::nonNull);
        artifacts.add(mcjar);
        return Stream.concat(artifacts.stream().map(f -> new IModLocator.ModFileOrException(f, null)), othermods).toList();
    }

    private IModFileInfo buildMinecraftTOML(IModFile iModFile) {
        ModFile modFile = (ModFile)iModFile;
        Config conf = Config.inMemory();
        conf.set("modLoader", (Object)"minecraft");
        conf.set("loaderVersion", (Object)"1");
        conf.set("license", (Object)"Mojang Studios, All Rights Reserved");
        Config mods = Config.inMemory();
        mods.set("modId", (Object)"minecraft");
        mods.set("version", (Object)FMLLoader.versionInfo().mcVersion());
        mods.set("displayName", (Object)"Minecraft");
        mods.set("logoFile", (Object)"mcplogo.png");
        mods.set("credits", (Object)"Mojang, deobfuscated by MCP");
        mods.set("authors", (Object)"MCP: Searge,ProfMobius,IngisKahn,Fesh0r,ZeuX,R4wk,LexManos,Bspkrs");
        mods.set("description", (Object)"Minecraft, decompiled and deobfuscated with MCP technology");
        conf.set("mods", List.of(mods));
        NightConfigWrapper configWrapper = new NightConfigWrapper((UnmodifiableConfig)conf);
        return new ModFileInfo(modFile, configWrapper, configWrapper::setFile, List.of());
    }

    public String name() {
        return "minecraft";
    }

    public void scanFile(IModFile modFile, Consumer<Path> pathConsumer) {
        LOGGER.debug(LogMarkers.SCAN, "Scan started: {}", (Object)modFile);
        try (Stream<Path> files = Files.find(modFile.getSecureJar().getRootPath(), Integer.MAX_VALUE, (p, a) -> p.getNameCount() > 0 && p.getFileName().toString().endsWith(".class"), new FileVisitOption[0]);){
            files.forEach(pathConsumer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOGGER.debug(LogMarkers.SCAN, "Scan finished: {}", (Object)modFile);
    }

    public void initArguments(Map<String, ?> arguments) {
    }
}

