/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.moddiscovery.CoreModFile;
import net.neoforged.fml.loading.moddiscovery.InvalidModFileException;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.fml.loading.moddiscovery.NightConfigWrapper;
import net.neoforged.neoforgespi.language.IConfigurable;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.ModFileFactory;
import org.slf4j.Logger;

public class ModFileParser {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static IModFileInfo readModList(ModFile modFile, ModFileFactory.ModFileInfoParser parser) {
        return parser.build((IModFile)modFile);
    }

    public static IModFileInfo modsTomlParser(IModFile imodFile) {
        ModFile modFile = (ModFile)imodFile;
        LOGGER.debug(LogMarkers.LOADING, "Considering mod file candidate {}", (Object)modFile.getFilePath());
        Path modsjson = modFile.findResource("META-INF", "mods.toml");
        if (!Files.exists(modsjson, new LinkOption[0])) {
            LOGGER.warn(LogMarkers.LOADING, "Mod file {} is missing mods.toml file", (Object)modFile.getFilePath());
            return null;
        }
        FileConfig fileConfig = FileConfig.builder((Path)modsjson).build();
        fileConfig.load();
        fileConfig.close();
        NightConfigWrapper configWrapper = new NightConfigWrapper((UnmodifiableConfig)fileConfig);
        return new ModFileInfo(modFile, configWrapper, configWrapper::setFile);
    }

    protected static List<CoreModFile> getCoreMods(ModFile modFile) {
        Map coreModPaths;
        try {
            Path coremodsjson = modFile.findResource("META-INF", "coremods.json");
            if (!Files.exists(coremodsjson, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            Gson gson = new Gson();
            coreModPaths = (Map)gson.fromJson((Reader)Files.newBufferedReader(coremodsjson), type);
        }
        catch (IOException e2) {
            LOGGER.debug(LogMarkers.LOADING, "Failed to read coremod list coremods.json", (Throwable)e2);
            return Collections.emptyList();
        }
        return coreModPaths.entrySet().stream().peek(e -> LOGGER.debug(LogMarkers.LOADING, "Found coremod {} with Javascript path {}", e.getKey(), e.getValue())).map(e -> new CoreModFile((String)e.getKey(), modFile.findResource((String)e.getValue()), modFile)).toList();
    }

    protected static List<String> getMixinConfigs(IModFileInfo modFileInfo) {
        try {
            IConfigurable config = modFileInfo.getConfig();
            List mixinsEntries = config.getConfigList(new String[]{"mixins"});
            return mixinsEntries.stream().map(entry -> (String)entry.getConfigElement(new String[]{"config"}).orElseThrow(() -> new InvalidModFileException("Missing \"config\" in [[mixins]] entry", modFileInfo))).toList();
        }
        catch (Exception exception) {
            LOGGER.error("Failed to load mixin configs from mod file", (Throwable)exception);
            return List.of();
        }
    }

    protected static Optional<List<String>> getAccessTransformers(IModFileInfo modFileInfo) {
        try {
            IConfigurable config = modFileInfo.getConfig();
            List atEntries = config.getConfigList(new String[]{"accessTransformers"});
            if (atEntries.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(atEntries.stream().map(entry -> (String)entry.getConfigElement(new String[]{"file"}).orElseThrow(() -> new InvalidModFileException("Missing \"file\" in [[accessTransformers]] entry", modFileInfo))).toList());
        }
        catch (Exception exception) {
            LOGGER.error("Failed to load access transformers from mod file", (Throwable)exception);
            return Optional.of(List.of());
        }
    }
}

