/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.ITransformationService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.neoforged.fml.loading.EarlyLoadingException;
import net.neoforged.fml.loading.ImmediateWindowHandler;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.ModSorter;
import net.neoforged.fml.loading.moddiscovery.BackgroundScanHandler;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ModValidator {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<IModFile.Type, List<ModFile>> modFiles;
    private final List<ModFile> candidatePlugins;
    private final List<ModFile> candidateMods;
    private LoadingModList loadingModList;
    private List<IModFile> brokenFiles;
    private final List<EarlyLoadingException.ExceptionData> discoveryErrorData;

    public ModValidator(Map<IModFile.Type, List<ModFile>> modFiles, List<IModFileInfo> brokenFiles, List<EarlyLoadingException.ExceptionData> discoveryErrorData) {
        this.modFiles = modFiles;
        this.candidateMods = ModValidator.lst(modFiles.get(IModFile.Type.MOD));
        this.candidateMods.addAll(ModValidator.lst(modFiles.get(IModFile.Type.GAMELIBRARY)));
        this.candidatePlugins = ModValidator.lst(modFiles.get(IModFile.Type.LANGPROVIDER));
        this.candidatePlugins.addAll(ModValidator.lst(modFiles.get(IModFile.Type.LIBRARY)));
        this.discoveryErrorData = discoveryErrorData;
        this.brokenFiles = brokenFiles.stream().map(IModFileInfo::getFile).collect(Collectors.toList());
    }

    private static List<ModFile> lst(@Nullable List<ModFile> files) {
        return files == null ? new ArrayList<ModFile>() : new ArrayList<ModFile>(files);
    }

    public void stage1Validation() {
        this.brokenFiles.addAll(this.validateFiles(this.candidateMods));
        if (LOGGER.isDebugEnabled(LogMarkers.SCAN)) {
            LOGGER.debug(LogMarkers.SCAN, "Found {} mod files with {} mods", (Object)this.candidateMods.size(), (Object)this.candidateMods.stream().mapToInt(mf -> mf.getModInfos().size()).sum());
        }
        ImmediateWindowHandler.updateProgress("Found " + this.candidateMods.size() + " mod candidates");
    }

    @NotNull
    private List<ModFile> validateFiles(List<ModFile> mods) {
        ArrayList<ModFile> brokenFiles = new ArrayList<ModFile>();
        Iterator<ModFile> iterator = mods.iterator();
        while (iterator.hasNext()) {
            ModFile modFile = iterator.next();
            if (modFile.getProvider().isValid((IModFile)modFile) && modFile.identifyMods()) continue;
            LOGGER.warn(LogMarkers.SCAN, "File {} has been ignored - it is invalid", (Object)modFile.getFilePath());
            iterator.remove();
            brokenFiles.add(modFile);
        }
        return brokenFiles;
    }

    public ITransformationService.Resource getPluginResources() {
        return new ITransformationService.Resource(IModuleLayerManager.Layer.PLUGIN, this.candidatePlugins.stream().map(IModFile::getSecureJar).toList());
    }

    public ITransformationService.Resource getModResources() {
        Stream<ModFile> modFilesToLoad = Stream.concat(this.loadingModList.getModFiles().stream().map(ModFileInfo::getFile), ModValidator.lst(this.modFiles.get(IModFile.Type.GAMELIBRARY)).stream());
        return new ITransformationService.Resource(IModuleLayerManager.Layer.GAME, modFilesToLoad.map(ModFile::getSecureJar).toList());
    }

    private List<EarlyLoadingException.ExceptionData> validateLanguages() {
        ArrayList<EarlyLoadingException.ExceptionData> errorData = new ArrayList<EarlyLoadingException.ExceptionData>();
        Iterator<ModFile> iterator = this.candidateMods.iterator();
        while (iterator.hasNext()) {
            ModFile modFile = iterator.next();
            try {
                modFile.identifyLanguage();
            }
            catch (EarlyLoadingException e) {
                errorData.addAll(e.getAllData());
                iterator.remove();
            }
        }
        return errorData;
    }

    public BackgroundScanHandler stage2Validation() {
        List<EarlyLoadingException.ExceptionData> errors = this.validateLanguages();
        ArrayList<EarlyLoadingException.ExceptionData> allErrors = new ArrayList<EarlyLoadingException.ExceptionData>(errors);
        allErrors.addAll(this.discoveryErrorData);
        this.loadingModList = ModSorter.sort(this.candidateMods, allErrors);
        this.loadingModList.addCoreMods();
        this.loadingModList.addAccessTransformers();
        this.loadingModList.addMixinConfigs();
        this.loadingModList.setBrokenFiles(this.brokenFiles);
        BackgroundScanHandler backgroundScanHandler = new BackgroundScanHandler();
        this.loadingModList.addForScanning(backgroundScanHandler);
        return backgroundScanHandler;
    }
}

