/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml;

import com.google.common.collect.Streams;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import net.neoforged.fml.i18n.FMLTranslations;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import org.jetbrains.annotations.Nullable;

public record ModLoadingIssue(Severity severity, String translationKey, List<Object> translationArgs, @Nullable Throwable cause, @Nullable Path affectedPath, @Nullable IModFile affectedModFile, @Nullable IModInfo affectedMod) {
    public ModLoadingIssue(Severity severity, String translationKey, List<Object> translationArgs) {
        this(severity, translationKey, translationArgs, null, null, null, null);
    }

    public static ModLoadingIssue error(String translationKey, Object ... args) {
        return new ModLoadingIssue(Severity.ERROR, translationKey, List.of(args));
    }

    public static ModLoadingIssue warning(String translationKey, Object ... args) {
        return new ModLoadingIssue(Severity.WARNING, translationKey, List.of(args));
    }

    public ModLoadingIssue withAffectedPath(Path affectedPath) {
        return new ModLoadingIssue(this.severity, this.translationKey, this.translationArgs, this.cause, affectedPath, null, null);
    }

    public ModLoadingIssue withAffectedModFile(IModFile affectedModFile) {
        Path affectedPath = affectedModFile.getFilePath();
        return new ModLoadingIssue(this.severity, this.translationKey, this.translationArgs, this.cause, affectedPath, affectedModFile, null);
    }

    public ModLoadingIssue withAffectedMod(IModInfo affectedMod) {
        IModFile affectedModFile = affectedMod.getOwningFile().getFile();
        Path affectedPath = affectedModFile.getFilePath();
        return new ModLoadingIssue(this.severity, this.translationKey, this.translationArgs, this.cause, affectedPath, affectedModFile, affectedMod);
    }

    public ModLoadingIssue withCause(Throwable cause) {
        return new ModLoadingIssue(this.severity, this.translationKey, this.translationArgs, cause, this.affectedPath, this.affectedModFile, this.affectedMod);
    }

    public String getTranslatedMessage() {
        Object[] formattingArgs = this.severity == Severity.ERROR ? Streams.concat((Stream[])new Stream[]{Stream.of(this.affectedMod, null, this.cause), this.translationArgs.stream()}).toArray() : Streams.concat((Stream[])new Stream[]{Stream.of(this.affectedMod, null), this.translationArgs.stream()}).toArray();
        return FMLTranslations.parseEnglishMessage(this.translationKey, formattingArgs);
    }

    @Override
    public String toString() {
        return String.valueOf((Object)this.severity) + ": " + this.getTranslatedMessage();
    }

    public static enum Severity {
        WARNING,
        ERROR;

    }
}

