/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.IncompatibleEnvironmentException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpecBuilder;
import net.neoforged.fml.loading.FMLConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.LaunchContext;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.VersionInfo;
import net.neoforged.neoforgespi.Environment;
import net.neoforged.neoforgespi.ILaunchContext;
import org.slf4j.Logger;

public class FMLServiceProvider
implements ITransformationService {
    private static final Logger LOGGER = LogUtils.getLogger();
    private ArgumentAcceptingOptionSpec<String> modsOption;
    private ArgumentAcceptingOptionSpec<String> modListsOption;
    private ArgumentAcceptingOptionSpec<String> mavenRootsOption;
    private ArgumentAcceptingOptionSpec<String> mixinConfigsOption;
    private ArgumentAcceptingOptionSpec<String> fmlOption;
    private ArgumentAcceptingOptionSpec<String> forgeOption;
    private ArgumentAcceptingOptionSpec<String> mcOption;
    private ArgumentAcceptingOptionSpec<String> mcpOption;
    private List<String> modsArgumentList;
    private List<String> modListsArgumentList;
    private List<String> mavenRootsArgumentList;
    private List<String> mixinConfigsArgumentList;
    private VersionInfo versionInfo;
    private ILaunchContext launchContext;

    public FMLServiceProvider() {
        String markerselection = System.getProperty("forge.logging.markers", "");
        Arrays.stream(markerselection.split(",")).forEach(marker -> System.setProperty("forge.logging.marker." + marker.toLowerCase(Locale.ROOT), "ACCEPT"));
    }

    public String name() {
        return "fml";
    }

    public void initialize(IEnvironment environment) {
        LOGGER.debug(LogMarkers.CORE, "Setting up basic FML game directories");
        FMLPaths.setup(environment);
        LOGGER.debug(LogMarkers.CORE, "Loading configuration");
        FMLConfig.load();
        IModuleLayerManager moduleLayerManager = (IModuleLayerManager)environment.findModuleLayerManager().orElseThrow();
        this.launchContext = new LaunchContext(environment, moduleLayerManager, this.modListsArgumentList, this.modsArgumentList, this.mavenRootsArgumentList);
        LOGGER.debug(LogMarkers.CORE, "Preparing launch handler");
        FMLLoader.setupLaunchHandler(environment, this.versionInfo);
        FMLEnvironment.setupInteropEnvironment(environment);
        Environment.build(environment);
    }

    public List<ITransformationService.Resource> beginScanning(IEnvironment environment) {
        LOGGER.debug(LogMarkers.CORE, "Initiating mod scan");
        return FMLLoader.beginModScan(this.launchContext);
    }

    public List<ITransformationService.Resource> completeScan(IModuleLayerManager layerManager) {
        Supplier<ModuleLayer> gameLayerSupplier = () -> (ModuleLayer)layerManager.getLayer(IModuleLayerManager.Layer.GAME).orElseThrow();
        return FMLLoader.completeScan(this.launchContext, this.mixinConfigsArgumentList);
    }

    public void onLoad(IEnvironment environment, Set<String> otherServices) throws IncompatibleEnvironmentException {
        FMLLoader.onInitialLoad(environment);
    }

    public void arguments(BiFunction<String, String, OptionSpecBuilder> argumentBuilder) {
        this.forgeOption = argumentBuilder.apply("neoForgeVersion", "NeoForge Version number").withRequiredArg().ofType(String.class).required();
        this.fmlOption = argumentBuilder.apply("fmlVersion", "FML Version number").withRequiredArg().ofType(String.class).required();
        this.mcOption = argumentBuilder.apply("mcVersion", "Minecraft Version number").withRequiredArg().ofType(String.class).required();
        this.mcpOption = argumentBuilder.apply("neoFormVersion", "Neoform Version number").withRequiredArg().ofType(String.class).required();
        this.modsOption = argumentBuilder.apply("mods", "List of mods to add").withRequiredArg().ofType(String.class).withValuesSeparatedBy(",");
        this.modListsOption = argumentBuilder.apply("modLists", "JSON modlists").withRequiredArg().ofType(String.class).withValuesSeparatedBy(",");
        this.mavenRootsOption = argumentBuilder.apply("mavenRoots", "Maven root directories").withRequiredArg().ofType(String.class).withValuesSeparatedBy(",");
        this.mixinConfigsOption = argumentBuilder.apply("mixinConfig", "Additional mixin config files to load").withRequiredArg().ofType(String.class);
    }

    public void argumentValues(ITransformationService.OptionResult option) {
        this.modsArgumentList = option.values(this.modsOption);
        this.modListsArgumentList = option.values(this.modListsOption);
        this.mavenRootsArgumentList = option.values(this.mavenRootsOption);
        this.mixinConfigsArgumentList = option.values(this.mixinConfigsOption);
        this.versionInfo = new VersionInfo((String)option.value(this.forgeOption), (String)option.value(this.fmlOption), (String)option.value(this.mcOption), (String)option.value(this.mcpOption));
        LOGGER.debug(LogMarkers.CORE, "Received command line version data  : {}", (Object)this.versionInfo);
    }

    public List<? extends ITransformer<?>> transformers() {
        LOGGER.debug(LogMarkers.CORE, "Loading coremod transformers");
        return FMLLoader.getCoreModEngine().initializeCoreMods();
    }
}

