/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.api.LambdaExceptionUtils;
import java.net.URL;
import java.security.CodeSigner;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.StringUtils;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.moddiscovery.ModInfo;
import net.neoforged.neoforgespi.language.IConfigurable;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.MavenVersionAdapter;
import net.neoforged.neoforgespi.locating.InvalidModFileException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

public class ModFileInfo
implements IModFileInfo,
IConfigurable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final IConfigurable config;
    private final ModFile modFile;
    private final URL issueURL;
    private final List<IModFileInfo.LanguageSpec> languageSpecs;
    private final boolean showAsResourcePack;
    private final boolean showAsDataPack;
    private final List<IModInfo> mods;
    private final Map<String, Object> properties;
    private final String license;
    private final List<String> usesServices;

    @ApiStatus.Internal
    public ModFileInfo(ModFile modFile, IConfigurable config, Consumer<IModFileInfo> configFileConsumer) {
        this.modFile = modFile;
        this.config = config;
        configFileConsumer.accept(this);
        String modLoader = (String)config.getConfigElement("modLoader").orElseThrow(() -> new InvalidModFileException("Missing ModLoader in file", this));
        VersionRange modLoaderVersion = config.getConfigElement("loaderVersion").map(MavenVersionAdapter::createFromVersionSpec).orElseThrow(() -> new InvalidModFileException("Missing ModLoader version in file", this));
        this.languageSpecs = new ArrayList<IModFileInfo.LanguageSpec>(List.of(new IModFileInfo.LanguageSpec(modLoader, modLoaderVersion)));
        this.license = config.getConfigElement("license").orElse("");
        if (this.license.isBlank()) {
            throw new InvalidModFileException("fml.modloading.missinglicense", this);
        }
        this.showAsResourcePack = config.getConfigElement("showAsResourcePack").orElse(false);
        this.showAsDataPack = config.getConfigElement("showAsDataPack").orElse(false);
        this.usesServices = config.getConfigElement("services").orElse(List.of());
        this.properties = config.getConfigElement("properties").orElse(Collections.emptyMap());
        this.modFile.setFileProperties(this.properties);
        this.issueURL = config.getConfigElement("issueTrackerURL").map(StringUtils::toURL).orElse(null);
        List<? extends IConfigurable> modConfigs = config.getConfigList("mods");
        if (modConfigs.isEmpty()) {
            throw new InvalidModFileException("Missing mods list", this);
        }
        this.mods = modConfigs.stream().map(mi -> new ModInfo(this, (IConfigurable)mi)).toList();
        if (LOGGER.isDebugEnabled(LogMarkers.LOADING)) {
            LOGGER.debug(LogMarkers.LOADING, "Found valid mod file {} with {} mods - versions {}", new Object[]{this.modFile.getFileName(), this.mods.stream().map(IModInfo::getModId).collect(Collectors.joining(",", "{", "}")), this.mods.stream().map(IModInfo::getVersion).map(Objects::toString).collect(Collectors.joining(",", "{", "}"))});
        }
    }

    public ModFileInfo(ModFile file, IConfigurable config, Consumer<IModFileInfo> configFileConsumer, List<IModFileInfo.LanguageSpec> languageSpecs) {
        this(file, config, configFileConsumer);
        this.languageSpecs.addAll(languageSpecs);
    }

    @Override
    public List<IModInfo> getMods() {
        return this.mods;
    }

    @Override
    public ModFile getFile() {
        return this.modFile;
    }

    @Override
    public List<IModFileInfo.LanguageSpec> requiredLanguageLoaders() {
        return this.languageSpecs;
    }

    @Override
    public Map<String, Object> getFileProperties() {
        return this.properties;
    }

    @Override
    public boolean showAsResourcePack() {
        return this.showAsResourcePack;
    }

    @Override
    public boolean showAsDataPack() {
        return this.showAsDataPack;
    }

    @Override
    public <T> Optional<T> getConfigElement(String ... key) {
        return this.config.getConfigElement(key);
    }

    @Override
    public List<? extends IConfigurable> getConfigList(String ... key) {
        return this.config.getConfigList(key);
    }

    @Override
    public String getLicense() {
        return this.license;
    }

    @Override
    public IConfigurable getConfig() {
        return this;
    }

    public URL getIssueURL() {
        return this.issueURL;
    }

    public Optional<String> getCodeSigningFingerprint() {
        CodeSigner[] signers = this.modFile.getSecureJar().getManifestSigners();
        return (signers == null ? Stream.of(new CodeSigner[0]) : Arrays.stream(signers)).flatMap(csa -> csa.getSignerCertPath().getCertificates().stream()).findFirst().map(LambdaExceptionUtils.rethrowFunction(Certificate::getEncoded)).map(bytes -> ((MessageDigest)LambdaExceptionUtils.uncheck(() -> MessageDigest.getInstance("SHA-256"))).digest((byte[])bytes)).map(StringUtils::binToHex).map(str -> String.join((CharSequence)":", str.split("(?<=\\G.{2})")));
    }

    public Optional<String> getTrustData() {
        return Arrays.stream(this.modFile.getSecureJar().getManifestSigners()).flatMap(csa -> csa.getSignerCertPath().getCertificates().stream()).findFirst().map(X509Certificate.class::cast).map(c -> {
            StringBuffer sb = new StringBuffer();
            sb.append(c.getSubjectX500Principal().getName("RFC2253").split(",")[0]);
            boolean selfSigned = false;
            try {
                c.verify(c.getPublicKey());
                selfSigned = true;
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException generalSecurityException) {
                // empty catch block
            }
            if (selfSigned) {
                sb.append(" self-signed");
            } else {
                sb.append(" signed by ").append(c.getIssuerX500Principal().getName("RFC2253").split(",")[0]);
            }
            return sb.toString();
        });
    }

    @Override
    public String moduleName() {
        return this.getMods().get(0).getModId();
    }

    @Override
    public String versionString() {
        return this.getMods().get(0).getVersion().toString();
    }

    @Override
    public List<String> usesServices() {
        return this.usesServices;
    }

    public String toString() {
        return this.moduleName();
    }
}

