/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml;

import com.mojang.logging.LogUtils;
import java.util.function.Supplier;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import org.slf4j.Logger;

public class ModLoadingContext {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ThreadLocal<ModLoadingContext> context = ThreadLocal.withInitial(ModLoadingContext::new);
    private Object languageExtension;
    private ModContainer activeContainer;

    public static ModLoadingContext get() {
        return context.get();
    }

    public void setActiveContainer(ModContainer container) {
        this.activeContainer = container;
        this.languageExtension = container == null ? null : container.contextExtension.get();
    }

    public ModContainer getActiveContainer() {
        return this.activeContainer == null ? ModList.get().getModContainerById("minecraft").orElseThrow(() -> new RuntimeException("Where is minecraft???!")) : this.activeContainer;
    }

    public String getActiveNamespace() {
        return this.activeContainer == null ? "minecraft" : this.activeContainer.getNamespace();
    }

    public <T extends IExtensionPoint> void registerExtensionPoint(Class<T> point, Supplier<T> extension) {
        this.getActiveContainer().registerExtensionPoint(point, extension);
    }

    @Deprecated(forRemoval=true)
    public void registerConfig(ModConfig.Type type, IConfigSpec<?> spec) {
        this.getActiveContainer().registerConfig(type, spec);
    }

    @Deprecated(forRemoval=true)
    public void registerConfig(ModConfig.Type type, IConfigSpec<?> spec, String fileName) {
        this.getActiveContainer().registerConfig(type, spec, fileName);
    }

    public <T> T extension() {
        return (T)this.languageExtension;
    }
}

