/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery.locators;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.StringUtils;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import net.neoforged.neoforgespi.locating.IncompatibleFileReporting;
import net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes;
import org.slf4j.Logger;

public class ModsFolderLocator
implements IModFileCandidateLocator {
    private static final String SUFFIX = ".jar";
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Path modFolder;
    private final String customName;

    public ModsFolderLocator() {
        this(FMLPaths.MODSDIR.get());
    }

    ModsFolderLocator(Path modFolder) {
        this(modFolder, "mods folder");
    }

    public ModsFolderLocator(Path modFolder, String name) {
        this.modFolder = Objects.requireNonNull(modFolder, "modFolder");
        this.customName = Objects.requireNonNull(name, "name");
    }

    @Override
    public void findCandidates(ILaunchContext context, IDiscoveryPipeline pipeline) {
        List<Path> directoryContent;
        LOGGER.debug(LogMarkers.SCAN, "Scanning mods dir {} for mods", (Object)this.modFolder);
        try (Stream<Path> files = Files.list(this.modFolder);){
            directoryContent = files.filter(p -> StringUtils.toLowerCase(p.getFileName().toString()).endsWith(SUFFIX)).sorted(Comparator.comparing(path -> StringUtils.toLowerCase(path.getFileName().toString()))).toList();
        }
        catch (IOException | UncheckedIOException e) {
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloading.failed_to_list_folder_content", this.modFolder).withAffectedPath(this.modFolder).withCause(e));
        }
        for (Path file : directoryContent) {
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                pipeline.addIssue(ModLoadingIssue.warning("fml.modloading.brokenfile.unknown", file).withAffectedPath(file));
                continue;
            }
            pipeline.addPath(file, ModFileDiscoveryAttributes.DEFAULT, IncompatibleFileReporting.WARN_ALWAYS);
        }
    }

    public String toString() {
        return "{" + this.customName + " locator at " + String.valueOf(this.modFolder) + "}";
    }
}

