/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery.locators;

import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.JarContentsBuilder;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.LibraryFinder;
import net.neoforged.fml.loading.MavenCoordinate;
import net.neoforged.fml.loading.VersionInfo;
import net.neoforged.fml.loading.moddiscovery.ModJarMetadata;
import net.neoforged.fml.loading.moddiscovery.locators.MinecraftModInfo;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;

public class ProductionServerProvider
implements IModFileCandidateLocator {
    private final List<MavenCoordinate> additionalContent;

    public ProductionServerProvider(List<MavenCoordinate> additionalContent) {
        this.additionalContent = additionalContent;
    }

    @Override
    public void findCandidates(ILaunchContext context, IDiscoveryPipeline pipeline) {
        VersionInfo vers = FMLLoader.versionInfo();
        try {
            Path mc = LibraryFinder.findPathForMaven("net.minecraft", "server", "", "srg", vers.mcAndNeoFormVersion());
            if (!Files.exists(mc, new LinkOption[0])) {
                pipeline.addIssue(ModLoadingIssue.error("fml.modloading.corrupted_installation", new Object[0]).withAffectedPath(mc));
                return;
            }
            Path mcextra = LibraryFinder.findPathForMaven("net.minecraft", "server", "", "extra", vers.mcAndNeoFormVersion());
            if (!Files.exists(mcextra, new LinkOption[0])) {
                pipeline.addIssue(ModLoadingIssue.error("fml.modloading.corrupted_installation", new Object[0]).withAffectedPath(mc));
                return;
            }
            SecureJar mcextra_filtered = SecureJar.from((JarContents)new JarContentsBuilder().pathFilter((path, base) -> path.equals("META-INF/versions/") || !path.endsWith(".class") && !path.startsWith("META-INF/")).paths(new Path[]{mcextra}).build());
            ArrayList<Path> content = new ArrayList<Path>();
            content.add(mc);
            content.add(mcextra_filtered.getRootPath());
            for (MavenCoordinate artifact : this.additionalContent) {
                Path extraPath = LibraryFinder.findPathForMaven(artifact);
                if (!Files.exists(extraPath, new LinkOption[0])) {
                    pipeline.addIssue(ModLoadingIssue.error("fml.modloading.corrupted_installation", new Object[0]).withAffectedPath(extraPath));
                    return;
                }
                content.add(extraPath);
            }
            JarContents mcJarContents = JarContents.of(content);
            ModJarMetadata mcJarMetadata = new ModJarMetadata(mcJarContents);
            SecureJar mcSecureJar = SecureJar.from((JarContents)mcJarContents, (JarMetadata)mcJarMetadata);
            IModFile mcjar = IModFile.create(mcSecureJar, MinecraftModInfo::buildMinecraftModInfo);
            mcJarMetadata.setModFile(mcjar);
            pipeline.addModFile(mcjar);
        }
        catch (Exception e) {
            pipeline.addIssue(ModLoadingIssue.error("fml.modloading.corrupted_installation", new Object[0]).withCause(e));
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder("production server provider");
        for (MavenCoordinate mavenCoordinate : this.additionalContent) {
            result.append(" +").append(mavenCoordinate);
        }
        return result.toString();
    }

    @Override
    public int getPriority() {
        return 1000;
    }
}

