/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.targets;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.VersionInfo;
import net.minecraftforge.fml.loading.targets.CommonDevLaunchHandler;
import net.minecraftforge.fml.loading.targets.CommonLaunchHandler;

public abstract class CommonUserdevLaunchHandler
extends CommonDevLaunchHandler {
    @Override
    public CommonLaunchHandler.LocatedPaths getMinecraftPaths() {
        VersionInfo vers = FMLLoader.versionInfo();
        Stream.Builder<Path> mcstream = Stream.builder();
        Stream.Builder<List<Path>> modstream = Stream.builder();
        String[] legacyCP = Objects.requireNonNull(System.getProperty("legacyClassPath"), "Missing legacyClassPath, cannot find userdev jars").split(File.pathSeparator);
        Path extra = CommonUserdevLaunchHandler.findJarOnClasspath(legacyCP, "client-extra");
        this.processStreams(legacyCP, vers, mcstream, modstream);
        this.getModClasses().forEach((modid, paths) -> modstream.add((List<Path>)paths));
        List<Path> minecraft = mcstream.build().collect(Collectors.toList());
        BiPredicate<String, String> mcFilter = this.getMcFilter(extra, minecraft, modstream);
        minecraft.add(extra);
        return new CommonLaunchHandler.LocatedPaths(minecraft, mcFilter, modstream.build().toList(), this.getFmlPaths(legacyCP));
    }

    protected abstract void processStreams(String[] var1, VersionInfo var2, Stream.Builder<Path> var3, Stream.Builder<List<Path>> var4);
}

