/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;

public class InterModComms {
    private static ConcurrentMap<String, ConcurrentLinkedQueue<IMCMessage>> containerQueues = new ConcurrentHashMap<String, ConcurrentLinkedQueue<IMCMessage>>();

    public static boolean sendTo(String modId, String method, Supplier<?> thing) {
        if (!ModList.get().isLoaded(modId)) {
            return false;
        }
        containerQueues.computeIfAbsent(modId, k -> new ConcurrentLinkedQueue()).add(new IMCMessage(ModLoadingContext.get().getActiveContainer().getModId(), modId, method, thing));
        return true;
    }

    public static boolean sendTo(String senderModId, String modId, String method, Supplier<?> thing) {
        if (!ModList.get().isLoaded(modId)) {
            return false;
        }
        containerQueues.computeIfAbsent(modId, k -> new ConcurrentLinkedQueue()).add(new IMCMessage(senderModId, modId, method, thing));
        return true;
    }

    public static Stream<IMCMessage> getMessages(String modId, Predicate<String> methodMatcher) {
        ConcurrentLinkedQueue queue = (ConcurrentLinkedQueue)containerQueues.get(modId);
        if (queue == null) {
            return Stream.empty();
        }
        return StreamSupport.stream(new QueueFilteringSpliterator(queue, methodMatcher), false);
    }

    public static Stream<IMCMessage> getMessages(String modId) {
        return InterModComms.getMessages(modId, s -> Boolean.TRUE);
    }

    public record IMCMessage(String senderModId, String modId, String method, Supplier<?> messageSupplier) {
    }

    private static class QueueFilteringSpliterator
    implements Spliterator<IMCMessage> {
        private final ConcurrentLinkedQueue<IMCMessage> queue;
        private final Predicate<String> methodFilter;
        private final Iterator<IMCMessage> iterator;

        public QueueFilteringSpliterator(ConcurrentLinkedQueue<IMCMessage> queue, Predicate<String> methodFilter) {
            this.queue = queue;
            this.iterator = queue.iterator();
            this.methodFilter = methodFilter;
        }

        @Override
        public int characteristics() {
            return 4368;
        }

        @Override
        public long estimateSize() {
            return this.queue.size();
        }

        @Override
        public boolean tryAdvance(Consumer<? super IMCMessage> action) {
            IMCMessage next;
            do {
                if (!this.iterator.hasNext()) {
                    return false;
                }
                next = this.iterator.next();
            } while (!this.methodFilter.test(next.method));
            action.accept(next);
            this.iterator.remove();
            return true;
        }

        @Override
        public Spliterator<IMCMessage> trySplit() {
            return null;
        }
    }
}

