/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.targets;

import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.LibraryFinder;
import net.neoforged.fml.loading.MavenCoordinate;
import net.neoforged.fml.loading.VersionInfo;
import net.neoforged.fml.loading.moddiscovery.locators.PathBasedLocator;
import net.neoforged.fml.loading.moddiscovery.locators.ProductionClientProvider;
import net.neoforged.fml.loading.targets.CommonLaunchHandler;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;

public class NeoForgeClientLaunchHandler
extends CommonLaunchHandler {
    @Override
    public String name() {
        return "neoforgeclient";
    }

    @Override
    public Dist getDist() {
        return Dist.CLIENT;
    }

    @Override
    public boolean isProduction() {
        return true;
    }

    @Override
    protected void runService(String[] arguments, ModuleLayer gameLayer) throws Throwable {
        this.clientService(arguments, gameLayer);
    }

    @Override
    public void collectAdditionalModFileLocators(VersionInfo versionInfo, Consumer<IModFileCandidateLocator> output) {
        super.collectAdditionalModFileLocators(versionInfo, output);
        List<MavenCoordinate> additionalContent = List.of(new MavenCoordinate("net.neoforged", "neoforge", "", "client", versionInfo.neoForgeVersion()));
        output.accept(new ProductionClientProvider(additionalContent));
        Path nfJar = LibraryFinder.findPathForMaven("net.neoforged", "neoforge", "", "universal", versionInfo.neoForgeVersion());
        output.accept(new PathBasedLocator("neoforge", nfJar));
    }
}

