/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery.locators;

import com.google.common.collect.Streams;
import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.JarContentsBuilder;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.moddiscovery.ModJarMetadata;
import net.neoforged.fml.loading.moddiscovery.locators.MinecraftModInfo;
import net.neoforged.fml.loading.moddiscovery.locators.NeoForgeDevDistCleaner;
import net.neoforged.fml.loading.moddiscovery.readers.JarModsDotTomlModFileReader;
import net.neoforged.fml.util.DevEnvUtils;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import net.neoforged.neoforgespi.locating.IncompatibleFileReporting;
import net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeoForgeDevProvider
implements IModFileCandidateLocator {
    private static final Logger LOG = LoggerFactory.getLogger(NeoForgeDevProvider.class);
    private static final Attributes.Name NAME_DISTS = new Attributes.Name("Minecraft-Dists");
    private static final Attributes.Name NAME_DIST = new Attributes.Name("Minecraft-Dist");
    private final List<Path> paths;

    public NeoForgeDevProvider(List<Path> paths) {
        this.paths = paths;
    }

    @Override
    public void findCandidates(ILaunchContext context, IDiscoveryPipeline pipeline) {
        Path minecraftResourcesRoot = null;
        String legacyClassPath = System.getProperty("legacyClassPath");
        if (legacyClassPath != null) {
            minecraftResourcesRoot = Arrays.stream(legacyClassPath.split(File.pathSeparator)).map(x$0 -> Path.of(x$0, new String[0])).filter(path -> path.getFileName().toString().contains("client-extra")).findFirst().orElse(null);
        }
        if (minecraftResourcesRoot == null) {
            minecraftResourcesRoot = DevEnvUtils.findFileSystemRootOfFileOnClasspath("data/.mcassetsroot");
            if (this.paths.size() == 1 && this.paths.getFirst().equals(minecraftResourcesRoot)) {
                LOG.info("Assuming Minecraft Jar is: {}", (Object)minecraftResourcesRoot);
                IModFile modFile = pipeline.addPath(minecraftResourcesRoot, ModFileDiscoveryAttributes.DEFAULT, IncompatibleFileReporting.IGNORE).orElse(null);
                if (modFile == null) {
                    pipeline.addIssue(ModLoadingIssue.error("fml.modloadingissue.corrupted_minecraft_jar", new Object[0]));
                } else if (modFile.getModInfos().isEmpty() || !modFile.getModInfos().getFirst().getModId().equals("minecraft")) {
                    throw new IllegalStateException("The detected Minecraft jar " + String.valueOf(minecraftResourcesRoot) + " does not contain a mod identifying as 'minecraft'. It contains: " + String.valueOf(modFile.getModInfos()));
                }
                return;
            }
        }
        String[] packages = NeoForgeDevProvider.getNeoForgeSpecificPathPrefixes();
        Path minecraftResourcesPrefix = minecraftResourcesRoot;
        HashSet<String> maskedPaths = new HashSet<String>();
        JarContents mcJarContents = new JarContentsBuilder().paths((Path[])Streams.concat((Stream[])new Stream[]{this.paths.stream(), Stream.of(minecraftResourcesRoot)}).toArray(Path[]::new)).pathFilter((entry, basePath) -> {
            if (maskedPaths.contains(entry)) {
                LOG.debug("Masking access to {} since it's from a different Minecraft distribution.", (Object)entry);
                return false;
            }
            if (basePath.equals(minecraftResourcesPrefix) || entry.endsWith("/")) {
                return true;
            }
            if (!entry.endsWith(".class")) {
                return false;
            }
            for (String pkg : packages) {
                if (!entry.startsWith(pkg)) continue;
                return false;
            }
            return true;
        }).build();
        NeoForgeDevDistCleaner neoForgeDevDistCleaner = (NeoForgeDevDistCleaner)context.environment().findLaunchPlugin("neoforgedevdistcleaner").orElseThrow();
        this.loadMaskedFiles(mcJarContents, maskedPaths, neoForgeDevDistCleaner, pipeline);
        ModJarMetadata mcJarMetadata = new ModJarMetadata(mcJarContents);
        SecureJar mcSecureJar = SecureJar.from((JarContents)mcJarContents, (JarMetadata)mcJarMetadata);
        IModFile minecraftModFile = IModFile.create(mcSecureJar, MinecraftModInfo::buildMinecraftModInfo);
        mcJarMetadata.setModFile(minecraftModFile);
        pipeline.addModFile(minecraftModFile);
        JarContents neoforgeJarContents = new JarContentsBuilder().paths((Path[])this.paths.toArray(Path[]::new)).pathFilter((entry, basePath) -> {
            if (!entry.endsWith(".class")) {
                return true;
            }
            for (String pkg : packages) {
                if (!entry.startsWith(pkg)) continue;
                return true;
            }
            return false;
        }).build();
        pipeline.addModFile(JarModsDotTomlModFileReader.createModFile(neoforgeJarContents, ModFileDiscoveryAttributes.DEFAULT));
    }

    private void loadMaskedFiles(JarContents minecraftJar, Set<String> maskedPaths, NeoForgeDevDistCleaner neoForgeDevDistCleaner, IDiscoveryPipeline pipeline) {
        String dist;
        Manifest manifest = minecraftJar.getManifest();
        String dists = manifest.getMainAttributes().getValue(NAME_DISTS);
        if (dists == null) {
            pipeline.addIssue(ModLoadingIssue.error("fml.modloadingissue.neodev_missing_dists_attribute", NAME_DISTS));
            return;
        }
        switch (FMLLoader.getDist()) {
            default: {
                throw new MatchException(null, null);
            }
            case CLIENT: {
                String string = "client";
                break;
            }
            case DEDICATED_SERVER: {
                String string = dist = "server";
            }
        }
        if (Arrays.stream(dists.split("\\s+")).allMatch(s -> s.equals(dist))) {
            return;
        }
        if (Arrays.stream(dists.split("\\s+")).noneMatch(s -> s.equals(dist))) {
            pipeline.addIssue(ModLoadingIssue.error("fml.modloadingissue.neodev_missing_appropriate_dist", dist, NAME_DISTS));
            return;
        }
        HashSet<String> strippedClasses = new HashSet<String>();
        for (Map.Entry<String, Attributes> entry : manifest.getEntries().entrySet()) {
            String filePath = entry.getKey();
            String fileDist = entry.getValue().getValue(NAME_DIST);
            if (fileDist == null || fileDist.equals(dist)) continue;
            if (filePath.endsWith(".class")) {
                String className = filePath.substring(0, filePath.length() - ".class".length()).replace('/', '.');
                strippedClasses.add(className);
                continue;
            }
            maskedPaths.add(filePath);
        }
        neoForgeDevDistCleaner.maskClasses(strippedClasses);
    }

    private static String[] getNeoForgeSpecificPathPrefixes() {
        return new String[]{"net/neoforged/neoforge/", "META-INF/services/", "META-INF/neoforge.mods.toml"};
    }

    public String toString() {
        return "neoforge devenv provider (" + String.valueOf(this.paths) + ")";
    }
}

