/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery.locators;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.loading.LibraryFinder;
import net.neoforged.fml.loading.MavenCoordinate;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import net.neoforged.neoforgespi.locating.IncompatibleFileReporting;
import net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes;

public class ProductionProvider
implements IModFileCandidateLocator {
    private final MavenCoordinate minecraftArtifact;
    private final MavenCoordinate neoforgeArtifact;

    public ProductionProvider(MavenCoordinate minecraftArtifact, MavenCoordinate neoforgeArtifact) {
        this.minecraftArtifact = minecraftArtifact;
        this.neoforgeArtifact = neoforgeArtifact;
    }

    @Override
    public void findCandidates(ILaunchContext context, IDiscoveryPipeline pipeline) {
        Path minecraftJar = LibraryFinder.findPathForMaven(this.minecraftArtifact);
        if (!Files.exists(minecraftJar, new LinkOption[0])) {
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.missing_minecraft_jar", new Object[0]).withAffectedPath(minecraftJar));
        }
        if (pipeline.addPath(minecraftJar, ModFileDiscoveryAttributes.DEFAULT, IncompatibleFileReporting.IGNORE).isEmpty()) {
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.corrupted_minecraft_jar", new Object[0]).withAffectedPath(minecraftJar));
        }
        Path neoforgeJar = LibraryFinder.findPathForMaven(this.neoforgeArtifact);
        if (!Files.exists(neoforgeJar, new LinkOption[0])) {
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.missing_neoforge_jar", new Object[0]).withAffectedPath(neoforgeJar));
        }
        if (pipeline.addPath(neoforgeJar, ModFileDiscoveryAttributes.DEFAULT, IncompatibleFileReporting.IGNORE).isEmpty()) {
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.corrupted_neoforge_jar", new Object[0]).withAffectedPath(neoforgeJar));
        }
    }

    public String toString() {
        return "production locator";
    }

    @Override
    public int getPriority() {
        return 1000;
    }
}

