/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.jarhandling.impl;

import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.impl.JarSigningData;
import cpw.mods.niofs.union.UnionFileSystem;
import cpw.mods.niofs.union.UnionFileSystemProvider;
import cpw.mods.niofs.union.UnionPathFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class JarContentsImpl
implements JarContents {
    private static final UnionFileSystemProvider UFSP = (UnionFileSystemProvider)FileSystemProvider.installedProviders().stream().filter(fsp -> fsp.getScheme().equals("union")).findFirst().orElseThrow(() -> new IllegalStateException("Couldn't find UnionFileSystemProvider"));
    final UnionFileSystem filesystem;
    final JarSigningData signingData = new JarSigningData();
    private final Manifest manifest;
    private final Map<Path, Integer> nameOverrides;

    public JarContentsImpl(Path[] paths, Supplier<Manifest> defaultManifest, @Nullable UnionPathFilter pathFilter) {
        Path[] validPaths = (Path[])Arrays.stream(paths).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).toArray(Path[]::new);
        if (validPaths.length == 0) {
            throw new UncheckedIOException(new IOException("Invalid paths argument, contained no existing paths: " + Arrays.toString(paths)));
        }
        this.filesystem = UFSP.newFileSystem(pathFilter, validPaths);
        this.manifest = this.readManifestAndSigningData(defaultManifest, validPaths);
        this.nameOverrides = this.readMultiReleaseInfo();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Manifest readManifestAndSigningData(Supplier<Manifest> defaultManifest, Path[] validPaths) {
        try {
            int x = validPaths.length - 1;
            while (x >= 0) {
                Path path = validPaths[x];
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Path manfile = path.resolve("META-INF/MANIFEST.MF");
                    if (Files.exists(manfile, new LinkOption[0])) {
                        try (InputStream is = Files.newInputStream(manfile, new OpenOption[0]);){
                            Manifest manifest = new Manifest(is);
                            return manifest;
                        }
                    }
                } else {
                    try (JarInputStream jis = new JarInputStream(Files.newInputStream(path, new OpenOption[0]));){
                        this.signingData.readJarSigningData(jis);
                        if (jis.getManifest() != null) {
                            Manifest manifest = new Manifest(jis.getManifest());
                            return manifest;
                        }
                    }
                }
                --x;
            }
            return defaultManifest.get();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Map<Path, Integer> readMultiReleaseInfo() {
        HashMap<Path, Integer> hashMap;
        block10: {
            boolean isMultiRelease = Boolean.parseBoolean(this.getManifest().getMainAttributes().getValue("Multi-Release"));
            if (!isMultiRelease) {
                return Map.of();
            }
            Path vers = this.filesystem.getRoot().resolve("META-INF/versions");
            if (!Files.isDirectory(vers, new LinkOption[0])) {
                return Map.of();
            }
            Stream<Path> walk = Files.walk(vers, new FileVisitOption[0]);
            try {
                HashMap<Path, Integer> pathToJavaVersion = new HashMap<Path, Integer>();
                walk.filter(p -> !Files.isDirectory(p, new LinkOption[0])).forEach(p -> {
                    int javaVersion = Integer.parseInt(p.getName(2).toString());
                    Path remainder = p.subpath(3, p.getNameCount());
                    if (javaVersion <= Runtime.version().feature()) {
                        pathToJavaVersion.merge(remainder, javaVersion, Integer::max);
                    }
                });
                hashMap = pathToJavaVersion;
                if (walk == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException(ioe);
                }
            }
            walk.close();
        }
        return hashMap;
    }

    @Override
    public Path getPrimaryPath() {
        return this.filesystem.getPrimaryPath();
    }

    @Override
    public Optional<URI> findFile(String name) {
        Path rel = this.filesystem.getPath(name, new String[0]);
        if (this.nameOverrides.containsKey(rel)) {
            rel = this.filesystem.getPath("META-INF", "versions", this.nameOverrides.get(rel).toString()).resolve(rel);
        }
        return Optional.of(this.filesystem.getRoot().resolve(rel)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toUri);
    }

    @Override
    public InputStream openFile(String name) throws IOException {
        Path rel = this.filesystem.getPath(name, new String[0]);
        if (this.nameOverrides.containsKey(rel)) {
            rel = this.filesystem.getPath("META-INF", "versions", this.nameOverrides.get(rel).toString()).resolve(rel);
        }
        Path path = this.filesystem.getRoot().resolve(rel);
        try {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        catch (NoSuchFileException e) {
            return null;
        }
    }

    @Override
    public Manifest getManifest() {
        return this.manifest;
    }

    @Override
    public void close() throws IOException {
        this.filesystem.close();
    }

    public String toString() {
        return this.getPrimaryPath().toString();
    }
}

