/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.niofs.union;

import cpw.mods.niofs.union.UnionFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntBinaryOperator;
import java.util.stream.IntStream;

public class UnionPath
implements Path {
    private final UnionFileSystem fileSystem;
    private final boolean absolute;
    private final String[] pathParts;
    private UnionPath normalized;

    UnionPath(UnionFileSystem fileSystem, String ... pathParts) {
        this.fileSystem = fileSystem;
        if (pathParts.length == 0) {
            this.absolute = false;
            this.pathParts = new String[0];
        } else {
            StringBuilder joiner = new StringBuilder();
            for (int i = 0; i < pathParts.length; ++i) {
                String element = pathParts[i];
                if (element.isEmpty()) continue;
                joiner.append(element);
                if (i >= pathParts.length - 1) continue;
                joiner.append("/");
            }
            String longstring = joiner.toString();
            this.absolute = longstring.startsWith("/");
            this.pathParts = this.getPathParts(longstring);
        }
        this.normalized = null;
    }

    UnionPath(UnionFileSystem fileSystem, boolean absolute, String ... pathParts) {
        this(fileSystem, absolute, false, pathParts);
    }

    private UnionPath(UnionFileSystem fileSystem, boolean absolute, boolean isNormalized, String ... pathParts) {
        this.fileSystem = fileSystem;
        this.absolute = absolute;
        this.pathParts = pathParts;
        this.normalized = isNormalized ? this : null;
    }

    private String[] getPathParts(String longstring) {
        String clean = longstring.replace('\\', '/');
        int startIndex = 0;
        ArrayList<String> parts = new ArrayList<String>();
        while (startIndex != longstring.length()) {
            int index = clean.indexOf(47, startIndex);
            if (index == -1) {
                parts.add(clean.substring(startIndex));
                break;
            }
            if (index != startIndex) {
                parts.add(clean.substring(startIndex, index));
            }
            startIndex = index + 1;
        }
        return (String[])parts.toArray(String[]::new);
    }

    @Override
    public UnionFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public Path getRoot() {
        return this.fileSystem.getRoot();
    }

    @Override
    public Path getFileName() {
        if (this.pathParts.length > 0) {
            return new UnionPath(this.getFileSystem(), false, this.pathParts[this.pathParts.length - 1]);
        }
        return new UnionPath(this.fileSystem, false, new String[0]);
    }

    @Override
    public Path getParent() {
        if (this.pathParts.length > 0) {
            return new UnionPath(this.fileSystem, this.absolute, Arrays.copyOf(this.pathParts, this.pathParts.length - 1));
        }
        return null;
    }

    @Override
    public int getNameCount() {
        return this.pathParts.length;
    }

    @Override
    public Path getName(int index) {
        if (index < 0 || index > this.pathParts.length - 1) {
            throw new IllegalArgumentException();
        }
        return new UnionPath(this.fileSystem, false, this.pathParts[index]);
    }

    @Override
    public UnionPath subpath(int beginIndex, int endIndex) {
        if (!this.absolute && this.pathParts.length == 0 && beginIndex == 0 && endIndex == 1) {
            return new UnionPath(this.fileSystem, false, new String[0]);
        }
        if (beginIndex < 0 || beginIndex > this.pathParts.length - 1 || endIndex < 0 || endIndex > this.pathParts.length || beginIndex >= endIndex) {
            throw new IllegalArgumentException("Out of range " + beginIndex + " to " + endIndex + " for length " + this.pathParts.length);
        }
        if (!this.absolute && beginIndex == 0 && endIndex == this.pathParts.length) {
            return this;
        }
        return new UnionPath(this.fileSystem, false, Arrays.copyOfRange(this.pathParts, beginIndex, endIndex));
    }

    @Override
    public boolean startsWith(Path other) {
        if (other.getFileSystem() != this.getFileSystem()) {
            return false;
        }
        if (other instanceof UnionPath) {
            UnionPath bp = (UnionPath)other;
            if (this.absolute != bp.absolute) {
                return false;
            }
            return UnionPath.checkArraysMatch(this.pathParts, bp.pathParts, false);
        }
        return false;
    }

    @Override
    public boolean endsWith(Path other) {
        if (other.getFileSystem() != this.getFileSystem()) {
            return false;
        }
        if (other instanceof UnionPath) {
            UnionPath bp = (UnionPath)other;
            if (!this.absolute && bp.absolute) {
                return false;
            }
            return UnionPath.checkArraysMatch(this.pathParts, bp.pathParts, true);
        }
        return false;
    }

    private static boolean checkArraysMatch(String[] array1, String[] array2, boolean reverse) {
        int length = Math.min(array1.length, array2.length);
        IntBinaryOperator offset = reverse ? (l, i) -> l - i - 1 : (l, i) -> i;
        for (int i2 = 0; i2 < length; ++i2) {
            if (Objects.equals(array1[offset.applyAsInt(array1.length, i2)], array2[offset.applyAsInt(array2.length, i2)])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Path normalize() {
        if (this.normalized != null) {
            return this.normalized;
        }
        ArrayDeque<String> normpath = new ArrayDeque<String>();
        String[] stringArray = this.pathParts;
        int n = stringArray.length;
        block8: for (int i = 0; i < n; ++i) {
            String pathPart;
            switch (pathPart = stringArray[i]) {
                case ".": {
                    continue block8;
                }
                case "..": {
                    if (normpath.isEmpty() || ((String)normpath.getLast()).equals("..")) {
                        normpath.addLast(pathPart);
                        continue block8;
                    }
                    normpath.removeLast();
                    continue block8;
                }
                default: {
                    normpath.addLast(pathPart);
                }
            }
        }
        this.normalized = new UnionPath(this.fileSystem, this.absolute, true, normpath.toArray(new String[0]));
        return this.normalized;
    }

    @Override
    public Path resolve(Path other) {
        if (other instanceof UnionPath) {
            UnionPath path = (UnionPath)other;
            if (path.isAbsolute()) {
                return path;
            }
            String[] mergedParts = new String[this.pathParts.length + path.pathParts.length];
            System.arraycopy(this.pathParts, 0, mergedParts, 0, this.pathParts.length);
            System.arraycopy(path.pathParts, 0, mergedParts, this.pathParts.length, path.pathParts.length);
            return new UnionPath(this.fileSystem, this.absolute, mergedParts);
        }
        return other;
    }

    @Override
    public Path relativize(Path other) {
        if (other.getFileSystem() != this.getFileSystem()) {
            throw new IllegalArgumentException("Wrong filesystem");
        }
        if (other instanceof UnionPath) {
            int i;
            UnionPath p = (UnionPath)other;
            if (this.absolute != p.absolute) {
                // empty if block
            }
            int length = Math.min(this.pathParts.length, p.pathParts.length);
            for (i = 0; i < length && Objects.equals(this.pathParts[i], p.pathParts[i]); ++i) {
            }
            int remaining = this.pathParts.length - i;
            if (remaining == 0 && i == p.pathParts.length) {
                return new UnionPath(this.getFileSystem(), false, new String[0]);
            }
            if (remaining == 0) {
                return p.subpath(i, p.getNameCount());
            }
            String[] updots = (String[])IntStream.range(0, remaining).mapToObj(idx -> "..").toArray(String[]::new);
            if (i == p.pathParts.length) {
                return new UnionPath(this.getFileSystem(), false, updots);
            }
            UnionPath subpath = p.subpath(i, p.getNameCount());
            String[] mergedParts = new String[updots.length + subpath.pathParts.length];
            System.arraycopy(updots, 0, mergedParts, 0, updots.length);
            System.arraycopy(subpath.pathParts, 0, mergedParts, updots.length, subpath.pathParts.length);
            return new UnionPath(this.getFileSystem(), false, mergedParts);
        }
        throw new IllegalArgumentException("Wrong filesystem");
    }

    @Override
    public URI toUri() {
        try {
            return new URI(this.fileSystem.provider().getScheme(), null, this.fileSystem.getKey() + "!" + String.valueOf(this.toAbsolutePath()), null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        return this.fileSystem.getRoot().resolve(this);
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        return this.toAbsolutePath().normalize();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(Path other) {
        if (other instanceof UnionPath) {
            UnionPath path = (UnionPath)other;
            if (this.absolute && !path.absolute) {
                return 1;
            }
            if (!this.absolute && path.absolute) {
                return -1;
            }
            return Arrays.compare((Comparable[])this.pathParts, (Comparable[])path.pathParts);
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof UnionPath) {
            UnionPath p = (UnionPath)o;
            return p.getFileSystem() == this.getFileSystem() && this.absolute == p.absolute && Arrays.equals(this.pathParts, p.pathParts);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.fileSystem) + 31 * Arrays.hashCode(this.pathParts);
    }

    @Override
    public String toString() {
        String pathParts;
        String string = pathParts = this.pathParts.length == 1 ? this.pathParts[0] : String.join((CharSequence)"/", this.pathParts);
        if (this.absolute) {
            return "/" + pathParts;
        }
        return pathParts;
    }

    public InputStream buildInputStream() {
        return this.fileSystem.buildInputStream(this);
    }
}

