/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.generators;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public abstract class CustomLoaderBuilder<T extends ModelBuilder<T>> {
    protected final ResourceLocation loaderId;
    protected final T parent;
    protected final ExistingFileHelper existingFileHelper;
    protected final Map<String, Boolean> visibility = new LinkedHashMap<String, Boolean>();
    protected final boolean allowInlineElements;
    private boolean optional = false;

    @Deprecated(forRemoval=true, since="1.20.2")
    protected CustomLoaderBuilder(ResourceLocation loaderId, T parent, ExistingFileHelper existingFileHelper) {
        this(loaderId, parent, existingFileHelper, false);
    }

    protected CustomLoaderBuilder(ResourceLocation loaderId, T parent, ExistingFileHelper existingFileHelper, boolean allowInlineElements) {
        this.loaderId = loaderId;
        this.parent = parent;
        this.existingFileHelper = existingFileHelper;
        this.allowInlineElements = allowInlineElements;
    }

    public CustomLoaderBuilder<T> visibility(String partName, boolean show) {
        Preconditions.checkNotNull((Object)partName, (Object)"partName must not be null");
        this.visibility.put(partName, show);
        return this;
    }

    public CustomLoaderBuilder<T> optional() {
        Preconditions.checkState((boolean)this.allowInlineElements, (Object)"Only loaders with support for inline elements can be marked as optional");
        this.optional = true;
        return this;
    }

    public T end() {
        return this.parent;
    }

    public JsonObject toJson(JsonObject json) {
        if (this.optional) {
            JsonObject loaderObj = new JsonObject();
            loaderObj.addProperty("id", this.loaderId.toString());
            loaderObj.addProperty("optional", Boolean.valueOf(true));
            json.add("loader", (JsonElement)loaderObj);
        } else {
            json.addProperty("loader", this.loaderId.toString());
        }
        if (this.visibility.size() > 0) {
            JsonObject visibilityObj = new JsonObject();
            for (Map.Entry<String, Boolean> entry : this.visibility.entrySet()) {
                visibilityObj.addProperty(entry.getKey(), entry.getValue());
            }
            json.add("visibility", (JsonElement)visibilityObj);
        }
        return json;
    }
}

