/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface IShearable {
    default public boolean isShearable(ItemStack item, Level level, BlockPos pos) {
        Shearable shearable;
        IShearable iShearable = this;
        return !(iShearable instanceof Shearable) || (shearable = (Shearable)iShearable).readyForShearing();
    }

    default public List<ItemStack> onSheared(@Nullable Player player, ItemStack item, Level level, BlockPos pos, int fortune) {
        IShearable iShearable = this;
        if (iShearable instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)iShearable;
            iShearable = this;
            if (iShearable instanceof Shearable) {
                Shearable shearable = (Shearable)iShearable;
                if (!level.isClientSide) {
                    ArrayList drops = new ArrayList();
                    entity.captureDrops(drops);
                    shearable.shear(player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS);
                    return entity.captureDrops(null).stream().map(ItemEntity::getItem).toList();
                }
            }
        }
        return Collections.emptyList();
    }

    default public void spawnShearedDrop(Level level, BlockPos pos, ItemStack drop) {
        IShearable iShearable = this;
        if (iShearable instanceof SnowGolem) {
            SnowGolem golem = (SnowGolem)iShearable;
            golem.spawnAtLocation(drop, 1.7f);
        } else {
            iShearable = this;
            if (iShearable instanceof MushroomCow) {
                MushroomCow cow = (MushroomCow)iShearable;
                itemEntity = cow.spawnAtLocation(drop, cow.getBbHeight());
                if (itemEntity != null) {
                    itemEntity.setNoPickUpDelay();
                }
            } else {
                itemEntity = this;
                if (itemEntity instanceof LivingEntity) {
                    LivingEntity entity = (LivingEntity)itemEntity;
                    if ((itemEntity = entity.spawnAtLocation(drop, 1.0f)) != null) {
                        itemEntity.setDeltaMovement(itemEntity.getDeltaMovement().add((double)((entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.1f), (double)(entity.getRandom().nextFloat() * 0.05f), (double)((entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.1f)));
                    }
                } else {
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), drop));
                }
            }
        }
    }
}

