/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;

public class VillagerTradingManager {
    private static final Map<VillagerProfession, Int2ObjectMap<VillagerTrades.ItemListing[]>> VANILLA_TRADES = new HashMap<VillagerProfession, Int2ObjectMap<VillagerTrades.ItemListing[]>>();
    private static final Int2ObjectMap<VillagerTrades.ItemListing[]> WANDERER_TRADES = new Int2ObjectOpenHashMap();

    static void loadTrades(ServerAboutToStartEvent e) {
        VillagerTradingManager.postWandererEvent();
        VillagerTradingManager.postVillagerEvents();
    }

    private static void postWandererEvent() {
        NonNullList generic = NonNullList.create();
        NonNullList rare = NonNullList.create();
        Arrays.stream((VillagerTrades.ItemListing[])WANDERER_TRADES.get(1)).forEach(((List)generic)::add);
        Arrays.stream((VillagerTrades.ItemListing[])WANDERER_TRADES.get(2)).forEach(((List)rare)::add);
        NeoForge.EVENT_BUS.post((Event)new WandererTradesEvent((List<VillagerTrades.ItemListing>)generic, (List<VillagerTrades.ItemListing>)rare));
        VillagerTrades.WANDERING_TRADER_TRADES.put(1, (Object)generic.toArray(new VillagerTrades.ItemListing[0]));
        VillagerTrades.WANDERING_TRADER_TRADES.put(2, (Object)rare.toArray(new VillagerTrades.ItemListing[0]));
    }

    private static void postVillagerEvents() {
        for (VillagerProfession prof : BuiltInRegistries.VILLAGER_PROFESSION) {
            Int2ObjectMap<VillagerTrades.ItemListing[]> trades = VANILLA_TRADES.getOrDefault(prof, (Int2ObjectMap<VillagerTrades.ItemListing[]>)new Int2ObjectOpenHashMap());
            Int2ObjectOpenHashMap mutableTrades = new Int2ObjectOpenHashMap();
            for (int i = 1; i < 6; ++i) {
                mutableTrades.put(i, (Object)NonNullList.create());
            }
            trades.int2ObjectEntrySet().forEach(arg_0 -> VillagerTradingManager.lambda$postVillagerEvents$3((Int2ObjectMap)mutableTrades, arg_0));
            NeoForge.EVENT_BUS.post((Event)new VillagerTradesEvent((Int2ObjectMap<List<VillagerTrades.ItemListing>>)mutableTrades, prof));
            Int2ObjectOpenHashMap newTrades = new Int2ObjectOpenHashMap();
            mutableTrades.int2ObjectEntrySet().forEach(arg_0 -> VillagerTradingManager.lambda$postVillagerEvents$4((Int2ObjectMap)newTrades, arg_0));
            VillagerTrades.TRADES.put(prof, newTrades);
        }
    }

    private static /* synthetic */ void lambda$postVillagerEvents$4(Int2ObjectMap newTrades, Int2ObjectMap.Entry e) {
        newTrades.put(e.getIntKey(), (Object)((List)e.getValue()).toArray(new VillagerTrades.ItemListing[0]));
    }

    private static /* synthetic */ void lambda$postVillagerEvents$3(Int2ObjectMap mutableTrades, Int2ObjectMap.Entry e) {
        Arrays.stream((VillagerTrades.ItemListing[])e.getValue()).forEach(((List)mutableTrades.get(e.getIntKey()))::add);
    }

    private static /* synthetic */ void lambda$static$0(Int2ObjectMap copy, Int2ObjectMap.Entry ent) {
        copy.put(ent.getIntKey(), (Object)Arrays.copyOf((VillagerTrades.ItemListing[])ent.getValue(), ((VillagerTrades.ItemListing[])ent.getValue()).length));
    }

    static {
        VillagerTrades.TRADES.entrySet().forEach(e -> {
            Int2ObjectOpenHashMap copy = new Int2ObjectOpenHashMap();
            ((Int2ObjectMap)e.getValue()).int2ObjectEntrySet().forEach(arg_0 -> VillagerTradingManager.lambda$static$0((Int2ObjectMap)copy, arg_0));
            VANILLA_TRADES.put((VillagerProfession)e.getKey(), (Int2ObjectMap<VillagerTrades.ItemListing[]>)copy);
        });
        VillagerTrades.WANDERING_TRADER_TRADES.int2ObjectEntrySet().forEach(e -> WANDERER_TRADES.put(e.getIntKey(), (Object)Arrays.copyOf((VillagerTrades.ItemListing[])e.getValue(), ((VillagerTrades.ItemListing[])e.getValue()).length)));
    }
}

