/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.advancements.critereon;

import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.advancements.critereon.ICustomEntityPredicate;

public class PiglinNeutralArmorEntityPredicate
implements ICustomEntityPredicate {
    public static final PiglinNeutralArmorEntityPredicate INSTANCE = new PiglinNeutralArmorEntityPredicate();
    public static final Codec<PiglinNeutralArmorEntityPredicate> CODEC = Codec.unit((Object)INSTANCE);

    private PiglinNeutralArmorEntityPredicate() {
    }

    public Codec<PiglinNeutralArmorEntityPredicate> codec() {
        return CODEC;
    }

    @Override
    public boolean test(ServerLevel level, @Nullable Vec3 position, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            for (ItemStack armor : entity.getArmorSlots()) {
                if (armor.isEmpty() || !armor.makesPiglinsNeutral(living)) continue;
                return true;
            }
        }
        return false;
    }
}

