/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.conditions;

import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.conditions.AndCondition;
import net.neoforged.neoforge.common.conditions.FalseCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ItemExistsCondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.OrCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import net.neoforged.neoforge.common.conditions.TrueCondition;

public interface IConditionBuilder {
    default public ICondition and(ICondition ... values) {
        return new AndCondition(List.of(values));
    }

    default public ICondition FALSE() {
        return FalseCondition.INSTANCE;
    }

    default public ICondition TRUE() {
        return TrueCondition.INSTANCE;
    }

    default public ICondition not(ICondition value) {
        return new NotCondition(value);
    }

    default public ICondition or(ICondition ... values) {
        return new OrCondition(List.of(values));
    }

    default public ICondition itemExists(String namespace, String path) {
        return new ItemExistsCondition(namespace, path);
    }

    default public ICondition modLoaded(String modid) {
        return new ModLoadedCondition(modid);
    }

    default public ICondition tagEmpty(TagKey<Item> tag) {
        return new TagEmptyCondition(tag.location());
    }
}

