/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.crafting.ChildBasedIngredient;
import org.jetbrains.annotations.Nullable;

public class DifferenceIngredient
extends ChildBasedIngredient {
    public static final Codec<DifferenceIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.CODEC.fieldOf("base").forGetter(DifferenceIngredient::getBase), (App)Ingredient.CODEC.fieldOf("subtracted").forGetter(DifferenceIngredient::getSubtracted)).apply((Applicative)builder, DifferenceIngredient::new));
    public static final Codec<DifferenceIngredient> CODEC_NONEMPTY = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("base").forGetter(DifferenceIngredient::getBase), (App)Ingredient.CODEC_NONEMPTY.fieldOf("subtracted").forGetter(DifferenceIngredient::getSubtracted)).apply((Applicative)builder, DifferenceIngredient::new));
    private final Ingredient base;
    private final Ingredient subtracted;

    protected DifferenceIngredient(Ingredient base, Ingredient subtracted) {
        super(Arrays.stream(base.getValues()).map(value -> new SubtractingValue((Ingredient.Value)value, subtracted)), NeoForgeMod.DIFFERENCE_INGREDIENT_TYPE, List.of(base, subtracted));
        this.base = base;
        this.subtracted = subtracted;
    }

    public Ingredient getBase() {
        return this.base;
    }

    public Ingredient getSubtracted() {
        return this.subtracted;
    }

    @Override
    protected Stream<ItemStack> generateMatchingStacks() {
        return Arrays.stream(this.base.getItems()).filter(this.subtracted.negate());
    }

    @Override
    protected boolean testComplex(@Nullable ItemStack stack) {
        return this.base.test(stack) && !this.subtracted.test(stack);
    }

    public static DifferenceIngredient of(Ingredient base, Ingredient subtracted) {
        return new DifferenceIngredient(base, subtracted);
    }

    private record SubtractingValue(Ingredient.Value inner, Ingredient subtracted) implements Ingredient.Value
    {
        public Collection<ItemStack> getItems() {
            return this.inner().getItems().stream().filter(this.subtracted.negate()).toList();
        }
    }
}

