/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.extensions;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.extensions.IEntityExtension;
import net.neoforged.neoforge.fluids.FluidType;

public interface ILivingEntityExtension
extends IEntityExtension {
    default public LivingEntity self() {
        return (LivingEntity)this;
    }

    @Override
    default public boolean canSwimInFluidType(FluidType type) {
        if (type == NeoForgeMod.WATER_TYPE.value()) {
            return !this.self().isSensitiveToWater();
        }
        return IEntityExtension.super.canSwimInFluidType(type);
    }

    default public void jumpInFluid(FluidType type) {
        this.self().setDeltaMovement(this.self().getDeltaMovement().add(0.0, (double)0.04f * this.self().getAttributeValue((Attribute)NeoForgeMod.SWIM_SPEED.value()), 0.0));
    }

    default public void sinkInFluid(FluidType type) {
        this.self().setDeltaMovement(this.self().getDeltaMovement().add(0.0, (double)-0.04f * this.self().getAttributeValue((Attribute)NeoForgeMod.SWIM_SPEED.value()), 0.0));
    }

    default public boolean canDrownInFluidType(FluidType type) {
        if (type == NeoForgeMod.WATER_TYPE.value()) {
            return !this.self().canBreatheUnderwater();
        }
        return type.canDrownIn(this.self());
    }

    default public boolean moveInFluid(FluidState state, Vec3 movementVector, double gravity) {
        return state.move(this.self(), movementVector, gravity);
    }
}

