/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.internal.versions.neoform;

import net.neoforged.fml.Logging;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.JarVersionLookupHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NeoFormVersion {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String mcVersion;
    private static final String neoFormVersion;

    public static String getMCVersion() {
        return mcVersion;
    }

    public static String getMCPVersion() {
        return neoFormVersion;
    }

    static {
        LOGGER.debug(Logging.CORE, "NeoForm Version package {} from {}", (Object)NeoFormVersion.class.getPackage(), (Object)NeoFormVersion.class.getClassLoader());
        mcVersion = JarVersionLookupHandler.getSpecificationVersion(NeoFormVersion.class).orElse(FMLLoader.versionInfo().mcVersion());
        if (mcVersion == null) {
            throw new RuntimeException("Missing MC version, cannot continue");
        }
        neoFormVersion = JarVersionLookupHandler.getImplementationVersion(NeoFormVersion.class).orElse(FMLLoader.versionInfo().neoFormVersion());
        if (neoFormVersion == null) {
            throw new RuntimeException("Missing NeoForm version, cannot continue");
        }
        LOGGER.debug(Logging.CORE, "Found MC version information {}", (Object)mcVersion);
        LOGGER.debug(Logging.CORE, "Found NeoForm version information {}", (Object)neoFormVersion);
    }
}

