/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.items.wrapper;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public abstract class EntityEquipmentInvWrapper
implements IItemHandlerModifiable {
    protected final LivingEntity entity;
    protected final List<EquipmentSlot> slots;

    public EntityEquipmentInvWrapper(LivingEntity entity, EquipmentSlot.Type slotType) {
        this.entity = entity;
        ArrayList<EquipmentSlot> slots = new ArrayList<EquipmentSlot>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.getType() != slotType) continue;
            slots.add(slot);
        }
        this.slots = ImmutableList.copyOf(slots);
    }

    @Override
    public int getSlots() {
        return this.slots.size();
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return this.entity.getItemBySlot(this.validateSlotIndex(slot));
    }

    @Override
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        EquipmentSlot equipmentSlot = this.validateSlotIndex(slot);
        ItemStack existing = this.entity.getItemBySlot(equipmentSlot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.isEmpty()) {
            if (!ItemHandlerHelper.canItemStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.getCount();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            if (existing.isEmpty()) {
                this.entity.setItemSlot(equipmentSlot, reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, limit) : stack);
            } else {
                existing.grow(reachedLimit ? limit : stack.getCount());
            }
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, stack.getCount() - limit) : ItemStack.EMPTY;
    }

    @Override
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        EquipmentSlot equipmentSlot = this.validateSlotIndex(slot);
        ItemStack existing = this.entity.getItemBySlot(equipmentSlot);
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, existing.getMaxStackSize());
        if (existing.getCount() <= toExtract) {
            if (!simulate) {
                this.entity.setItemSlot(equipmentSlot, ItemStack.EMPTY);
            }
            return existing;
        }
        if (!simulate) {
            this.entity.setItemSlot(equipmentSlot, ItemHandlerHelper.copyStackWithSize(existing, existing.getCount() - toExtract));
        }
        return ItemHandlerHelper.copyStackWithSize(existing, toExtract);
    }

    @Override
    public int getSlotLimit(int slot) {
        EquipmentSlot equipmentSlot = this.validateSlotIndex(slot);
        return equipmentSlot.getType() == EquipmentSlot.Type.ARMOR ? 1 : 64;
    }

    protected int getStackLimit(int slot, ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.getMaxStackSize());
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        EquipmentSlot equipmentSlot = this.validateSlotIndex(slot);
        if (ItemStack.matches((ItemStack)this.entity.getItemBySlot(equipmentSlot), (ItemStack)stack)) {
            return;
        }
        this.entity.setItemSlot(equipmentSlot, stack);
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    protected EquipmentSlot validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.slots.size()) {
            throw new IllegalArgumentException("Slot " + slot + " not in valid range - [0," + this.slots.size() + ")");
        }
        return this.slots.get(slot);
    }
}

