/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.configuration;

import java.util.function.Consumer;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.tags.TagNetworkSerialization;
import net.neoforged.neoforge.network.configuration.ICustomConfigurationTask;
import net.neoforged.neoforge.network.payload.FrozenRegistrySyncCompletedPayload;
import net.neoforged.neoforge.network.payload.FrozenRegistrySyncStartPayload;
import net.neoforged.neoforge.registries.RegistryManager;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public record SyncRegistries() implements ICustomConfigurationTask
{
    private static final ResourceLocation ID = new ResourceLocation("neoforge", "sync_registries");
    public static final ConfigurationTask.Type TYPE = new ConfigurationTask.Type(ID);

    @Override
    public void run(Consumer<CustomPacketPayload> sender) {
        sender.accept(new FrozenRegistrySyncStartPayload(RegistryManager.getRegistryNamesForSyncToClient()));
        RegistryManager.generateRegistryPackets(false).forEach(sender);
        sender.accept(new FrozenRegistrySyncCompletedPayload());
    }

    @Override
    public void start(Consumer<Packet<?>> sender) {
        ICustomConfigurationTask.super.start(sender);
        sender.accept((Packet<?>)new ClientboundUpdateTagsPacket(TagNetworkSerialization.serializeTagsToNetwork((LayeredRegistryAccess)ServerLifecycleHooks.getCurrentServer().registries())));
    }

    public ConfigurationTask.Type type() {
        return TYPE;
    }
}

