/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.payload;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.neoforge.common.util.FriendlyByteBufUtil;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public record AdvancedOpenScreenPayload(int windowId, MenuType<?> menuType, Component name, byte[] additionalData) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("neoforge", "advanced_open_screen");

    public AdvancedOpenScreenPayload(int windowId, MenuType<?> menuType, Component name, Consumer<FriendlyByteBuf> dataWriter) {
        this(windowId, menuType, name, FriendlyByteBufUtil.writeCustomData(dataWriter));
    }

    public AdvancedOpenScreenPayload(FriendlyByteBuf buffer) {
        this(buffer.readVarInt(), Objects.requireNonNull((MenuType)buffer.readById((IdMap)BuiltInRegistries.MENU)), buffer.readComponentTrusted(), buffer.readByteArray());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeVarInt(this.windowId());
        buffer.writeId((IdMap)BuiltInRegistries.MENU, this.menuType());
        buffer.writeComponent(this.name());
        buffer.writeByteArray(this.additionalData());
    }

    public ResourceLocation id() {
        return ID;
    }
}

