/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.crafting;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.stream.Stream;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class CraftingHelper {
    public static Codec<Ingredient> makeIngredientCodec(boolean allowEmpty) {
        Codec listCodec = Codec.lazyInitialized(() -> allowEmpty ? Ingredient.LIST_CODEC : Ingredient.LIST_CODEC_NONEMPTY);
        return Codec.either((Codec)listCodec, (Codec)CraftingHelper.makeIngredientMapCodec().codec()).xmap(either -> (Ingredient)either.map(list -> CompoundIngredient.of((Ingredient[])list.toArray(Ingredient[]::new)), i -> i), ingredient -> {
            if (ingredient.isCustom()) {
                ICustomIngredient patt0$temp = ingredient.getCustomIngredient();
                if (patt0$temp instanceof CompoundIngredient) {
                    CompoundIngredient compound = (CompoundIngredient)patt0$temp;
                    return Either.left(compound.children());
                }
            } else if (ingredient.getValues().length != 1) {
                return Either.left(Stream.of(ingredient.getValues()).map(v -> Ingredient.fromValues(Stream.of(v))).toList());
            }
            return Either.right((Object)ingredient);
        });
    }

    public static MapCodec<Ingredient> makeIngredientMapCodec() {
        return NeoForgeExtraCodecs.dispatchMapOrElse(NeoForgeRegistries.INGREDIENT_TYPES.byNameCodec(), ICustomIngredient::getType, IngredientType::codec, Ingredient.Value.MAP_CODEC).xmap(either -> (Ingredient)either.map(ICustomIngredient::toVanilla, v -> Ingredient.fromValues(Stream.of(v))), ingredient -> {
            if (!ingredient.isCustom()) {
                Ingredient.Value[] values = ingredient.getValues();
                if (values.length == 1) {
                    return Either.right((Object)values[0]);
                }
                return Either.left((Object)new CompoundIngredient(Stream.of(ingredient.getValues()).map(v -> Ingredient.fromValues(Stream.of(v))).toList()));
            }
            return Either.left((Object)ingredient.getCustomIngredient());
        }).validate(ingredient -> {
            if (!ingredient.isCustom() && ingredient.getValues().length == 0) {
                return DataResult.error(() -> "Cannot serialize empty ingredient using the map codec");
            }
            return DataResult.success((Object)ingredient);
        });
    }
}

