/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.conditions;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagManager;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.Nullable;

public class ConditionContext
implements ICondition.IContext {
    private final TagManager tagManager;
    @Nullable
    private Map<ResourceKey<?>, Map<ResourceLocation, Collection<Holder<?>>>> loadedTags = null;

    public ConditionContext(TagManager tagManager) {
        this.tagManager = tagManager;
    }

    @Override
    public <T> Map<ResourceLocation, Collection<Holder<T>>> getAllTags(ResourceKey<? extends Registry<T>> registry) {
        if (this.loadedTags == null) {
            List tags = this.tagManager.getResult();
            if (tags.isEmpty()) {
                throw new IllegalStateException("Tags have not been loaded yet.");
            }
            this.loadedTags = new IdentityHashMap();
            for (TagManager.LoadResult loadResult : tags) {
                Map map = Collections.unmodifiableMap(loadResult.tags());
                this.loadedTags.put(loadResult.key(), map);
            }
        }
        return this.loadedTags.getOrDefault(registry, Collections.emptyMap());
    }
}

