/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.data.internal;

import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public final class NeoForgeItemTagsProvider
extends ItemTagsProvider {
    public NeoForgeItemTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagProvider, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, blockTagProvider, "neoforge", existingFileHelper);
    }

    public void addTags(HolderLookup.Provider lookupProvider) {
        this.copy(Tags.Blocks.BARRELS, Tags.Items.BARRELS);
        this.copy(Tags.Blocks.BARRELS_WOODEN, Tags.Items.BARRELS_WOODEN);
        this.tag(Tags.Items.BONES).add((Object)Items.BONE);
        this.copy(Tags.Blocks.BOOKSHELVES, Tags.Items.BOOKSHELVES);
        this.tag(Tags.Items.BRICKS).addTags(new TagKey[]{Tags.Items.BRICKS_NORMAL, Tags.Items.BRICKS_NETHER});
        this.tag(Tags.Items.BRICKS_NORMAL).add((Object)Items.BRICK);
        this.tag(Tags.Items.BRICKS_NETHER).add((Object)Items.NETHER_BRICK);
        this.tag(Tags.Items.BUCKETS_EMPTY).add((Object)Items.BUCKET);
        this.tag(Tags.Items.BUCKETS_WATER).add((Object)Items.WATER_BUCKET);
        this.tag(Tags.Items.BUCKETS_LAVA).add((Object)Items.LAVA_BUCKET);
        this.tag(Tags.Items.BUCKETS_MILK).add((Object)Items.MILK_BUCKET);
        this.tag(Tags.Items.BUCKETS_POWDER_SNOW).add((Object)Items.POWDER_SNOW_BUCKET);
        this.tag(Tags.Items.BUCKETS_ENTITY_WATER).add((Object[])new Item[]{Items.AXOLOTL_BUCKET, Items.COD_BUCKET, Items.PUFFERFISH_BUCKET, Items.TADPOLE_BUCKET, Items.TROPICAL_FISH_BUCKET, Items.SALMON_BUCKET});
        this.tag(Tags.Items.BUCKETS).addTags(new TagKey[]{Tags.Items.BUCKETS_EMPTY, Tags.Items.BUCKETS_WATER, Tags.Items.BUCKETS_LAVA, Tags.Items.BUCKETS_MILK, Tags.Items.BUCKETS_POWDER_SNOW, Tags.Items.BUCKETS_ENTITY_WATER});
        this.copy(Tags.Blocks.BUDDING_BLOCKS, Tags.Items.BUDDING_BLOCKS);
        this.copy(Tags.Blocks.BUDS, Tags.Items.BUDS);
        this.copy(Tags.Blocks.CHAINS, Tags.Items.CHAINS);
        this.copy(Tags.Blocks.CHESTS, Tags.Items.CHESTS);
        this.copy(Tags.Blocks.CHESTS_ENDER, Tags.Items.CHESTS_ENDER);
        this.copy(Tags.Blocks.CHESTS_TRAPPED, Tags.Items.CHESTS_TRAPPED);
        this.copy(Tags.Blocks.CHESTS_WOODEN, Tags.Items.CHESTS_WOODEN);
        this.copy(Tags.Blocks.CLUSTERS, Tags.Items.CLUSTERS);
        this.copy(Tags.Blocks.COBBLESTONES, Tags.Items.COBBLESTONES);
        this.copy(Tags.Blocks.COBBLESTONES_NORMAL, Tags.Items.COBBLESTONES_NORMAL);
        this.copy(Tags.Blocks.COBBLESTONES_INFESTED, Tags.Items.COBBLESTONES_INFESTED);
        this.copy(Tags.Blocks.COBBLESTONES_MOSSY, Tags.Items.COBBLESTONES_MOSSY);
        this.copy(Tags.Blocks.COBBLESTONES_DEEPSLATE, Tags.Items.COBBLESTONES_DEEPSLATE);
        this.tag(Tags.Items.CROPS).addTags(new TagKey[]{Tags.Items.CROPS_BEETROOT, Tags.Items.CROPS_CARROT, Tags.Items.CROPS_NETHER_WART, Tags.Items.CROPS_POTATO, Tags.Items.CROPS_WHEAT});
        this.tag(Tags.Items.CROPS_BEETROOT).add((Object)Items.BEETROOT);
        this.tag(Tags.Items.CROPS_CARROT).add((Object)Items.CARROT);
        this.tag(Tags.Items.CROPS_NETHER_WART).add((Object)Items.NETHER_WART);
        this.tag(Tags.Items.CROPS_POTATO).add((Object)Items.POTATO);
        this.tag(Tags.Items.CROPS_WHEAT).add((Object)Items.WHEAT);
        this.addColored(Tags.Items.DYED, "{color}_banner");
        this.addColored(Tags.Items.DYED, "{color}_bed");
        this.addColored(Tags.Items.DYED, "{color}_candle");
        this.addColored(Tags.Items.DYED, "{color}_carpet");
        this.addColored(Tags.Items.DYED, "{color}_concrete");
        this.addColored(Tags.Items.DYED, "{color}_concrete_powder");
        this.addColored(Tags.Items.DYED, "{color}_glazed_terracotta");
        this.addColored(Tags.Items.DYED, "{color}_shulker_box");
        this.addColored(Tags.Items.DYED, "{color}_stained_glass");
        this.addColored(Tags.Items.DYED, "{color}_stained_glass_pane");
        this.addColored(Tags.Items.DYED, "{color}_terracotta");
        this.addColored(Tags.Items.DYED, "{color}_wool");
        this.addColoredTags(arg_0 -> NeoForgeItemTagsProvider.lambda$addTags$0(this.tag(Tags.Items.DYED), arg_0), Tags.Items.DYED);
        this.tag(Tags.Items.DUSTS).addTags(new TagKey[]{Tags.Items.DUSTS_GLOWSTONE, Tags.Items.DUSTS_REDSTONE});
        this.tag(Tags.Items.DUSTS_GLOWSTONE).add((Object)Items.GLOWSTONE_DUST);
        this.tag(Tags.Items.DUSTS_REDSTONE).add((Object)Items.REDSTONE);
        this.addColored(Tags.Items.DYES, "{color}_dye");
        this.addColoredTags(arg_0 -> NeoForgeItemTagsProvider.lambda$addTags$1(this.tag(Tags.Items.DYES), arg_0), Tags.Items.DYES);
        this.tag(Tags.Items.EGGS).add((Object)Items.EGG);
        this.tag(Tags.Items.ENCHANTING_FUELS).addTag(Tags.Items.GEMS_LAPIS);
        this.copy(Tags.Blocks.END_STONES, Tags.Items.END_STONES);
        this.tag(Tags.Items.ENDER_PEARLS).add((Object)Items.ENDER_PEARL);
        this.tag(Tags.Items.FEATHERS).add((Object)Items.FEATHER);
        this.copy(Tags.Blocks.FENCE_GATES, Tags.Items.FENCE_GATES);
        this.copy(Tags.Blocks.FENCE_GATES_WOODEN, Tags.Items.FENCE_GATES_WOODEN);
        this.copy(Tags.Blocks.FENCES, Tags.Items.FENCES);
        this.copy(Tags.Blocks.FENCES_NETHER_BRICK, Tags.Items.FENCES_NETHER_BRICK);
        this.copy(Tags.Blocks.FENCES_WOODEN, Tags.Items.FENCES_WOODEN);
        this.tag(Tags.Items.FOODS_FRUITS).add((Object[])new Item[]{Items.APPLE, Items.GOLDEN_APPLE, Items.ENCHANTED_GOLDEN_APPLE});
        this.tag(Tags.Items.FOODS_VEGETABLES).add((Object[])new Item[]{Items.CARROT, Items.GOLDEN_CARROT, Items.POTATO, Items.MELON_SLICE, Items.BEETROOT});
        this.tag(Tags.Items.FOODS_BERRIES).add((Object[])new Item[]{Items.SWEET_BERRIES, Items.GLOW_BERRIES});
        this.tag(Tags.Items.FOODS_BREADS).add((Object)Items.BREAD);
        this.tag(Tags.Items.FOODS_COOKIES).add((Object)Items.COOKIE);
        this.tag(Tags.Items.FOODS_RAW_MEATS).add((Object[])new Item[]{Items.BEEF, Items.PORKCHOP, Items.CHICKEN, Items.RABBIT, Items.MUTTON});
        this.tag(Tags.Items.FOODS_RAW_FISHES).add((Object[])new Item[]{Items.COD, Items.SALMON, Items.TROPICAL_FISH, Items.PUFFERFISH});
        this.tag(Tags.Items.FOODS_COOKED_MEATS).add((Object[])new Item[]{Items.COOKED_BEEF, Items.COOKED_PORKCHOP, Items.COOKED_CHICKEN, Items.COOKED_RABBIT, Items.COOKED_MUTTON});
        this.tag(Tags.Items.FOODS_COOKED_FISHES).add((Object[])new Item[]{Items.COOKED_COD, Items.COOKED_SALMON});
        this.tag(Tags.Items.FOODS_SOUPS).add((Object[])new Item[]{Items.BEETROOT_SOUP, Items.MUSHROOM_STEW, Items.RABBIT_STEW, Items.SUSPICIOUS_STEW});
        this.tag(Tags.Items.FOODS_CANDIES);
        this.tag(Tags.Items.FOODS_EDIBLE_WHEN_PLACED).add((Object)Items.CAKE);
        this.tag(Tags.Items.FOODS_FOOD_POISONING).add((Object[])new Item[]{Items.POISONOUS_POTATO, Items.PUFFERFISH, Items.SPIDER_EYE, Items.CHICKEN, Items.ROTTEN_FLESH});
        this.tag(Tags.Items.FOODS).add((Object[])new Item[]{Items.BAKED_POTATO, Items.PUMPKIN_PIE, Items.HONEY_BOTTLE, Items.OMINOUS_BOTTLE, Items.DRIED_KELP}).addTags(new TagKey[]{Tags.Items.FOODS_FRUITS, Tags.Items.FOODS_VEGETABLES, Tags.Items.FOODS_BERRIES, Tags.Items.FOODS_BREADS, Tags.Items.FOODS_COOKIES, Tags.Items.FOODS_RAW_MEATS, Tags.Items.FOODS_RAW_FISHES, Tags.Items.FOODS_COOKED_MEATS, Tags.Items.FOODS_COOKED_FISHES, Tags.Items.FOODS_SOUPS, Tags.Items.FOODS_CANDIES, Tags.Items.FOODS_EDIBLE_WHEN_PLACED, Tags.Items.FOODS_FOOD_POISONING});
        this.tag(Tags.Items.GEMS).addTags(new TagKey[]{Tags.Items.GEMS_AMETHYST, Tags.Items.GEMS_DIAMOND, Tags.Items.GEMS_EMERALD, Tags.Items.GEMS_LAPIS, Tags.Items.GEMS_PRISMARINE, Tags.Items.GEMS_QUARTZ});
        this.tag(Tags.Items.GEMS_AMETHYST).add((Object)Items.AMETHYST_SHARD);
        this.tag(Tags.Items.GEMS_DIAMOND).add((Object)Items.DIAMOND);
        this.tag(Tags.Items.GEMS_EMERALD).add((Object)Items.EMERALD);
        this.tag(Tags.Items.GEMS_LAPIS).add((Object)Items.LAPIS_LAZULI);
        this.tag(Tags.Items.GEMS_PRISMARINE).add((Object)Items.PRISMARINE_CRYSTALS);
        this.tag(Tags.Items.GEMS_QUARTZ).add((Object)Items.QUARTZ);
        this.copy(Tags.Blocks.GLASS_BLOCKS, Tags.Items.GLASS_BLOCKS);
        this.copy(Tags.Blocks.GLASS_BLOCKS_COLORLESS, Tags.Items.GLASS_BLOCKS_COLORLESS);
        this.copy(Tags.Blocks.GLASS_BLOCKS_TINTED, Tags.Items.GLASS_BLOCKS_TINTED);
        this.copy(Tags.Blocks.GLASS_BLOCKS_CHEAP, Tags.Items.GLASS_BLOCKS_CHEAP);
        this.copy(Tags.Blocks.GLASS_PANES, Tags.Items.GLASS_PANES);
        this.copy(Tags.Blocks.GLASS_PANES_COLORLESS, Tags.Items.GLASS_PANES_COLORLESS);
        this.copy(Tags.Blocks.GRAVELS, Tags.Items.GRAVELS);
        this.tag(Tags.Items.GUNPOWDERS).add((Object)Items.GUNPOWDER);
        this.tag(Tags.Items.HIDDEN_FROM_RECIPE_VIEWERS);
        this.tag(Tags.Items.INGOTS).addTags(new TagKey[]{Tags.Items.INGOTS_COPPER, Tags.Items.INGOTS_GOLD, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_NETHERITE});
        this.tag(Tags.Items.INGOTS_COPPER).add((Object)Items.COPPER_INGOT);
        this.tag(Tags.Items.INGOTS_GOLD).add((Object)Items.GOLD_INGOT);
        this.tag(Tags.Items.INGOTS_IRON).add((Object)Items.IRON_INGOT);
        this.tag(Tags.Items.INGOTS_NETHERITE).add((Object)Items.NETHERITE_INGOT);
        this.tag(Tags.Items.LEATHERS).add((Object)Items.LEATHER);
        this.tag(Tags.Items.MUSHROOMS).add((Object[])new Item[]{Items.BROWN_MUSHROOM, Items.RED_MUSHROOM});
        this.tag(Tags.Items.NETHER_STARS).add((Object)Items.NETHER_STAR);
        this.copy(Tags.Blocks.NETHERRACKS, Tags.Items.NETHERRACKS);
        this.tag(Tags.Items.NUGGETS).addTags(new TagKey[]{Tags.Items.NUGGETS_GOLD, Tags.Items.NUGGETS_IRON});
        this.tag(Tags.Items.NUGGETS_IRON).add((Object)Items.IRON_NUGGET);
        this.tag(Tags.Items.NUGGETS_GOLD).add((Object)Items.GOLD_NUGGET);
        this.copy(Tags.Blocks.OBSIDIANS, Tags.Items.OBSIDIANS);
        this.copy(Tags.Blocks.ORE_BEARING_GROUND_DEEPSLATE, Tags.Items.ORE_BEARING_GROUND_DEEPSLATE);
        this.copy(Tags.Blocks.ORE_BEARING_GROUND_NETHERRACK, Tags.Items.ORE_BEARING_GROUND_NETHERRACK);
        this.copy(Tags.Blocks.ORE_BEARING_GROUND_STONE, Tags.Items.ORE_BEARING_GROUND_STONE);
        this.copy(Tags.Blocks.ORE_RATES_DENSE, Tags.Items.ORE_RATES_DENSE);
        this.copy(Tags.Blocks.ORE_RATES_SINGULAR, Tags.Items.ORE_RATES_SINGULAR);
        this.copy(Tags.Blocks.ORE_RATES_SPARSE, Tags.Items.ORE_RATES_SPARSE);
        this.copy(Tags.Blocks.ORES, Tags.Items.ORES);
        this.copy(Tags.Blocks.ORES_COAL, Tags.Items.ORES_COAL);
        this.copy(Tags.Blocks.ORES_COPPER, Tags.Items.ORES_COPPER);
        this.copy(Tags.Blocks.ORES_DIAMOND, Tags.Items.ORES_DIAMOND);
        this.copy(Tags.Blocks.ORES_EMERALD, Tags.Items.ORES_EMERALD);
        this.copy(Tags.Blocks.ORES_GOLD, Tags.Items.ORES_GOLD);
        this.copy(Tags.Blocks.ORES_IRON, Tags.Items.ORES_IRON);
        this.copy(Tags.Blocks.ORES_LAPIS, Tags.Items.ORES_LAPIS);
        this.copy(Tags.Blocks.ORES_QUARTZ, Tags.Items.ORES_QUARTZ);
        this.copy(Tags.Blocks.ORES_REDSTONE, Tags.Items.ORES_REDSTONE);
        this.copy(Tags.Blocks.ORES_NETHERITE_SCRAP, Tags.Items.ORES_NETHERITE_SCRAP);
        this.copy(Tags.Blocks.ORES_IN_GROUND_DEEPSLATE, Tags.Items.ORES_IN_GROUND_DEEPSLATE);
        this.copy(Tags.Blocks.ORES_IN_GROUND_NETHERRACK, Tags.Items.ORES_IN_GROUND_NETHERRACK);
        this.copy(Tags.Blocks.ORES_IN_GROUND_STONE, Tags.Items.ORES_IN_GROUND_STONE);
        this.copy(Tags.Blocks.PLAYER_WORKSTATIONS_CRAFTING_TABLES, Tags.Items.PLAYER_WORKSTATIONS_CRAFTING_TABLES);
        this.copy(Tags.Blocks.PLAYER_WORKSTATIONS_FURNACES, Tags.Items.PLAYER_WORKSTATIONS_FURNACES);
        this.tag(Tags.Items.RAW_BLOCKS).addTags(new TagKey[]{Tags.Items.RAW_BLOCKS_COPPER, Tags.Items.RAW_BLOCKS_GOLD, Tags.Items.RAW_BLOCKS_IRON});
        this.tag(Tags.Items.RAW_BLOCKS_COPPER).add((Object)Items.RAW_COPPER_BLOCK);
        this.tag(Tags.Items.RAW_BLOCKS_GOLD).add((Object)Items.RAW_GOLD_BLOCK);
        this.tag(Tags.Items.RAW_BLOCKS_IRON).add((Object)Items.RAW_IRON_BLOCK);
        this.tag(Tags.Items.RAW_MATERIALS).addTags(new TagKey[]{Tags.Items.RAW_MATERIALS_COPPER, Tags.Items.RAW_MATERIALS_GOLD, Tags.Items.RAW_MATERIALS_IRON});
        this.tag(Tags.Items.RAW_MATERIALS_COPPER).add((Object)Items.RAW_COPPER);
        this.tag(Tags.Items.RAW_MATERIALS_GOLD).add((Object)Items.RAW_GOLD);
        this.tag(Tags.Items.RAW_MATERIALS_IRON).add((Object)Items.RAW_IRON);
        this.tag(Tags.Items.RODS).addTags(new TagKey[]{Tags.Items.RODS_WOODEN, Tags.Items.RODS_BLAZE, Tags.Items.RODS_BREEZE});
        this.tag(Tags.Items.RODS_BLAZE).add((Object)Items.BLAZE_ROD);
        this.tag(Tags.Items.RODS_BREEZE).add((Object)Items.BREEZE_ROD);
        this.tag(Tags.Items.RODS_WOODEN).add((Object)Items.STICK);
        this.copy(Tags.Blocks.ROPES, Tags.Items.ROPES);
        this.copy(Tags.Blocks.SANDS, Tags.Items.SANDS);
        this.copy(Tags.Blocks.SANDS_COLORLESS, Tags.Items.SANDS_COLORLESS);
        this.copy(Tags.Blocks.SANDS_RED, Tags.Items.SANDS_RED);
        this.copy(Tags.Blocks.SANDSTONE_BLOCKS, Tags.Items.SANDSTONE_BLOCKS);
        this.copy(Tags.Blocks.SANDSTONE_SLABS, Tags.Items.SANDSTONE_SLABS);
        this.copy(Tags.Blocks.SANDSTONE_STAIRS, Tags.Items.SANDSTONE_STAIRS);
        this.copy(Tags.Blocks.SANDSTONE_RED_BLOCKS, Tags.Items.SANDSTONE_RED_BLOCKS);
        this.copy(Tags.Blocks.SANDSTONE_RED_SLABS, Tags.Items.SANDSTONE_RED_SLABS);
        this.copy(Tags.Blocks.SANDSTONE_RED_STAIRS, Tags.Items.SANDSTONE_RED_STAIRS);
        this.copy(Tags.Blocks.SANDSTONE_UNCOLORED_BLOCKS, Tags.Items.SANDSTONE_UNCOLORED_BLOCKS);
        this.copy(Tags.Blocks.SANDSTONE_UNCOLORED_SLABS, Tags.Items.SANDSTONE_UNCOLORED_SLABS);
        this.copy(Tags.Blocks.SANDSTONE_UNCOLORED_STAIRS, Tags.Items.SANDSTONE_UNCOLORED_STAIRS);
        this.tag(Tags.Items.SEEDS).addTags(new TagKey[]{Tags.Items.SEEDS_BEETROOT, Tags.Items.SEEDS_MELON, Tags.Items.SEEDS_PUMPKIN, Tags.Items.SEEDS_WHEAT});
        this.tag(Tags.Items.SEEDS_BEETROOT).add((Object)Items.BEETROOT_SEEDS);
        this.tag(Tags.Items.SEEDS_MELON).add((Object)Items.MELON_SEEDS);
        this.tag(Tags.Items.SEEDS_PUMPKIN).add((Object)Items.PUMPKIN_SEEDS);
        this.tag(Tags.Items.SEEDS_WHEAT).add((Object)Items.WHEAT_SEEDS);
        this.tag(Tags.Items.SLIMEBALLS).add((Object)Items.SLIME_BALL);
        this.copy(Tags.Blocks.STONES, Tags.Items.STONES);
        this.copy(Tags.Blocks.STORAGE_BLOCKS, Tags.Items.STORAGE_BLOCKS);
        this.copy(Tags.Blocks.STORAGE_BLOCKS_BONE_MEAL, Tags.Items.STORAGE_BLOCKS_BONE_MEAL);
        this.copy(Tags.Blocks.STORAGE_BLOCKS_COAL, Tags.Items.STORAGE_BLOCKS_COAL);
        this.copy(Tags.Blocks.STORAGE_BLOCKS_COPPER, Tags.Items.STORAGE_BLOCKS_COPPER);
        this.copy(Tags.Blocks.STORAGE_BLOCKS_DIAMOND, Tags.Items.STORAGE_BLOCKS_DIAMOND);
        this.copy(Tags.Blocks.STORAGE_BLOCKS_DRIED_KELP, Tags.Items.STORAGE_BLOCKS_DRIED_KELP);
        this.copy(Tags.Blocks.STORAGE_BLOCKS_EMERALD, Tags.Items.STORAGE_BLOCKS_EMERALD);
        this.copy(Tags.Blocks.STORAGE_BLOCKS_GOLD, Tags.Items.STORAGE_BLOCKS_GOLD);
        this.copy(Tags.Blocks.STORAGE_BLOCKS_IRON, Tags.Items.STORAGE_BLOCKS_IRON);
        this.copy(Tags.Blocks.STORAGE_BLOCKS_LAPIS, Tags.Items.STORAGE_BLOCKS_LAPIS);
        this.copy(Tags.Blocks.STORAGE_BLOCKS_NETHERITE, Tags.Items.STORAGE_BLOCKS_NETHERITE);
        this.copy(Tags.Blocks.STORAGE_BLOCKS_RAW_COPPER, Tags.Items.STORAGE_BLOCKS_RAW_COPPER);
        this.copy(Tags.Blocks.STORAGE_BLOCKS_RAW_GOLD, Tags.Items.STORAGE_BLOCKS_RAW_GOLD);
        this.copy(Tags.Blocks.STORAGE_BLOCKS_RAW_IRON, Tags.Items.STORAGE_BLOCKS_RAW_IRON);
        this.copy(Tags.Blocks.STORAGE_BLOCKS_REDSTONE, Tags.Items.STORAGE_BLOCKS_REDSTONE);
        this.copy(Tags.Blocks.STORAGE_BLOCKS_SLIME, Tags.Items.STORAGE_BLOCKS_SLIME);
        this.copy(Tags.Blocks.STORAGE_BLOCKS_WHEAT, Tags.Items.STORAGE_BLOCKS_WHEAT);
        this.tag(Tags.Items.STRINGS).add((Object)Items.STRING);
        this.tag(Tags.Items.VILLAGER_JOB_SITES).add((Object[])new Item[]{Items.BARREL, Items.BLAST_FURNACE, Items.BREWING_STAND, Items.CARTOGRAPHY_TABLE, Items.CAULDRON, Items.COMPOSTER, Items.FLETCHING_TABLE, Items.GRINDSTONE, Items.LECTERN, Items.LOOM, Items.SMITHING_TABLE, Items.SMOKER, Items.STONECUTTER});
        this.tag(Tags.Items.TOOLS_SHIELDS).add((Object)Items.SHIELD);
        this.tag(Tags.Items.TOOLS_BOWS).add((Object)Items.BOW);
        this.tag(Tags.Items.TOOLS_BRUSHES).add((Object)Items.BRUSH);
        this.tag(Tags.Items.TOOLS_CROSSBOWS).add((Object)Items.CROSSBOW);
        this.tag(Tags.Items.TOOLS_FISHING_RODS).add((Object)Items.FISHING_ROD);
        this.tag(Tags.Items.TOOLS_SHEARS).add((Object)Items.SHEARS);
        this.tag(Tags.Items.TOOLS_SPEARS).add((Object)Items.TRIDENT);
        this.tag(Tags.Items.TOOLS).addTags(new TagKey[]{ItemTags.AXES, ItemTags.HOES, ItemTags.PICKAXES, ItemTags.SHOVELS, ItemTags.SWORDS}).addTags(new TagKey[]{Tags.Items.TOOLS_BOWS, Tags.Items.TOOLS_BRUSHES, Tags.Items.TOOLS_CROSSBOWS, Tags.Items.TOOLS_FISHING_RODS, Tags.Items.TOOLS_SHEARS, Tags.Items.TOOLS_SHIELDS, Tags.Items.TOOLS_SPEARS});
        this.tag(Tags.Items.ARMORS).addTags(new TagKey[]{ItemTags.HEAD_ARMOR, ItemTags.CHEST_ARMOR, ItemTags.LEG_ARMOR, ItemTags.FOOT_ARMOR});
        this.tag(Tags.Items.ENCHANTABLES).addTags(new TagKey[]{ItemTags.ARMOR_ENCHANTABLE, ItemTags.EQUIPPABLE_ENCHANTABLE, ItemTags.WEAPON_ENCHANTABLE, ItemTags.SWORD_ENCHANTABLE, ItemTags.MINING_ENCHANTABLE, ItemTags.MINING_LOOT_ENCHANTABLE, ItemTags.FISHING_ENCHANTABLE, ItemTags.TRIDENT_ENCHANTABLE, ItemTags.BOW_ENCHANTABLE, ItemTags.CROSSBOW_ENCHANTABLE, ItemTags.FIRE_ASPECT_ENCHANTABLE, ItemTags.DURABILITY_ENCHANTABLE}).addOptionalTag(ItemTags.MACE_ENCHANTABLE);
        this.tagWithOptionalLegacy(Tags.Items.BONES);
        this.tag(Tags.Items.BRICKS_NORMAL).addOptionalTag(new ResourceLocation("forge", "ingots/brick"));
        this.tag(Tags.Items.BRICKS_NETHER).addOptionalTag(new ResourceLocation("forge", "ingots/nether_brick"));
        this.tagWithOptionalLegacy(Tags.Items.CROPS);
        this.tagWithOptionalLegacy(Tags.Items.CROPS_BEETROOT);
        this.tagWithOptionalLegacy(Tags.Items.CROPS_CARROT);
        this.tagWithOptionalLegacy(Tags.Items.CROPS_NETHER_WART);
        this.tagWithOptionalLegacy(Tags.Items.CROPS_POTATO);
        this.tagWithOptionalLegacy(Tags.Items.CROPS_WHEAT);
        this.tagWithOptionalLegacy(Tags.Items.DUSTS);
        this.tagWithOptionalLegacy(Tags.Items.DUSTS_GLOWSTONE);
        this.tagWithOptionalLegacy(Tags.Items.DUSTS_REDSTONE);
        this.tagColoredWithOptionalLegacy(Tags.Items.DYES);
        this.tag(Tags.Items.DYED_BLACK).addOptionalTag(new ResourceLocation("forge", "glass/black")).addOptionalTag(new ResourceLocation("forge", "stained_glass/black"));
        this.tag(Tags.Items.DYED_BLUE).addOptionalTag(new ResourceLocation("forge", "glass/blue")).addOptionalTag(new ResourceLocation("forge", "stained_glass/blue"));
        this.tag(Tags.Items.DYED_BROWN).addOptionalTag(new ResourceLocation("forge", "glass/brown")).addOptionalTag(new ResourceLocation("forge", "stained_glass/brown"));
        this.tag(Tags.Items.DYED_CYAN).addOptionalTag(new ResourceLocation("forge", "glass/cyan")).addOptionalTag(new ResourceLocation("forge", "stained_glass/cyan"));
        this.tag(Tags.Items.DYED_GRAY).addOptionalTag(new ResourceLocation("forge", "glass/gray")).addOptionalTag(new ResourceLocation("forge", "stained_glass/gray"));
        this.tag(Tags.Items.DYED_GREEN).addOptionalTag(new ResourceLocation("forge", "glass/green")).addOptionalTag(new ResourceLocation("forge", "stained_glass/green"));
        this.tag(Tags.Items.DYED_LIGHT_BLUE).addOptionalTag(new ResourceLocation("forge", "glass/light_blue")).addOptionalTag(new ResourceLocation("forge", "stained_glass/light_blue"));
        this.tag(Tags.Items.DYED_LIGHT_GRAY).addOptionalTag(new ResourceLocation("forge", "glass/light_gray")).addOptionalTag(new ResourceLocation("forge", "stained_glass/light_gray"));
        this.tag(Tags.Items.DYED_LIME).addOptionalTag(new ResourceLocation("forge", "glass/lime")).addOptionalTag(new ResourceLocation("forge", "stained_glass/lime"));
        this.tag(Tags.Items.DYED_MAGENTA).addOptionalTag(new ResourceLocation("forge", "glass/magenta")).addOptionalTag(new ResourceLocation("forge", "stained_glass/magenta"));
        this.tag(Tags.Items.DYED_MAGENTA).addOptionalTag(new ResourceLocation("forge", "glass/magenta")).addOptionalTag(new ResourceLocation("forge", "stained_glass/magenta"));
        this.tag(Tags.Items.DYED_ORANGE).addOptionalTag(new ResourceLocation("forge", "glass/orange")).addOptionalTag(new ResourceLocation("forge", "stained_glass/orange"));
        this.tag(Tags.Items.DYED_PINK).addOptionalTag(new ResourceLocation("forge", "glass/pink")).addOptionalTag(new ResourceLocation("forge", "stained_glass/pink"));
        this.tag(Tags.Items.DYED_PURPLE).addOptionalTag(new ResourceLocation("forge", "glass/purple")).addOptionalTag(new ResourceLocation("forge", "stained_glass/purple"));
        this.tag(Tags.Items.DYED_RED).addOptionalTag(new ResourceLocation("forge", "glass/red")).addOptionalTag(new ResourceLocation("forge", "stained_glass/red"));
        this.tag(Tags.Items.DYED_WHITE).addOptionalTag(new ResourceLocation("forge", "glass/white")).addOptionalTag(new ResourceLocation("forge", "stained_glass/white"));
        this.tag(Tags.Items.DYED_YELLOW).addOptionalTag(new ResourceLocation("forge", "glass/yellow")).addOptionalTag(new ResourceLocation("forge", "stained_glass/yellow"));
        this.tagWithOptionalLegacy(Tags.Items.ENDER_PEARLS);
        this.tagWithOptionalLegacy(Tags.Items.FEATHERS);
        this.tagWithOptionalLegacy(Tags.Items.GEMS);
        this.tagWithOptionalLegacy(Tags.Items.GEMS_AMETHYST);
        this.tagWithOptionalLegacy(Tags.Items.GEMS_DIAMOND);
        this.tagWithOptionalLegacy(Tags.Items.GEMS_EMERALD);
        this.tagWithOptionalLegacy(Tags.Items.GEMS_LAPIS);
        this.tagWithOptionalLegacy(Tags.Items.GEMS_PRISMARINE);
        this.tagWithOptionalLegacy(Tags.Items.GEMS_QUARTZ);
        this.tag(Tags.Items.GUNPOWDERS).addOptionalTag(new ResourceLocation("forge", "gunpowder"));
        this.tagWithOptionalLegacy(Tags.Items.INGOTS);
        this.tagWithOptionalLegacy(Tags.Items.INGOTS_COPPER);
        this.tagWithOptionalLegacy(Tags.Items.INGOTS_GOLD);
        this.tagWithOptionalLegacy(Tags.Items.INGOTS_IRON);
        this.tagWithOptionalLegacy(Tags.Items.INGOTS_NETHERITE);
        this.tag(Tags.Items.LEATHERS).addOptionalTag(new ResourceLocation("forge", "leather"));
        this.tagWithOptionalLegacy(Tags.Items.MUSHROOMS);
        this.tagWithOptionalLegacy(Tags.Items.NETHER_STARS);
        this.tagWithOptionalLegacy(Tags.Items.NUGGETS);
        this.tagWithOptionalLegacy(Tags.Items.NUGGETS_IRON);
        this.tagWithOptionalLegacy(Tags.Items.NUGGETS_GOLD);
        this.tagWithOptionalLegacy(Tags.Items.RAW_MATERIALS);
        this.tagWithOptionalLegacy(Tags.Items.RAW_MATERIALS_COPPER);
        this.tagWithOptionalLegacy(Tags.Items.RAW_MATERIALS_GOLD);
        this.tagWithOptionalLegacy(Tags.Items.RAW_MATERIALS_IRON);
        this.tagWithOptionalLegacy(Tags.Items.RODS);
        this.tagWithOptionalLegacy(Tags.Items.RODS_BLAZE);
        this.tagWithOptionalLegacy(Tags.Items.RODS_WOODEN);
        this.tagWithOptionalLegacy(Tags.Items.SEEDS);
        this.tagWithOptionalLegacy(Tags.Items.SEEDS_BEETROOT);
        this.tagWithOptionalLegacy(Tags.Items.SEEDS_MELON);
        this.tagWithOptionalLegacy(Tags.Items.SEEDS_PUMPKIN);
        this.tagWithOptionalLegacy(Tags.Items.SEEDS_WHEAT);
        this.tagWithOptionalLegacy(Tags.Items.SLIMEBALLS);
        this.tagWithOptionalLegacy(Tags.Items.STRINGS);
        this.tagWithOptionalLegacy(Tags.Items.TOOLS_SHIELDS);
        this.tagWithOptionalLegacy(Tags.Items.TOOLS_BOWS);
        this.tagWithOptionalLegacy(Tags.Items.TOOLS_CROSSBOWS);
        this.tagWithOptionalLegacy(Tags.Items.TOOLS_FISHING_RODS);
        this.tag(Tags.Items.TOOLS_SHEARS).addOptionalTag(new ResourceLocation("forge", "shears"));
        this.tag(Tags.Items.TOOLS_SPEARS).addOptionalTag(new ResourceLocation("forge", "tools/tridents"));
        this.tagWithOptionalLegacy(Tags.Items.TOOLS);
        this.tagWithOptionalLegacy(Tags.Items.ARMORS);
    }

    private IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item> tagWithOptionalLegacy(TagKey<Item> tag) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender tagAppender = this.tag(tag);
        tagAppender.addOptionalTag(new ResourceLocation("forge", tag.location().getPath()));
        return tagAppender;
    }

    private void tagColoredWithOptionalLegacy(TagKey<Item> group) {
        String prefix = group.location().getPath().toUpperCase(Locale.ENGLISH) + "_";
        for (DyeColor color : DyeColor.values()) {
            TagKey<Item> tag = this.getForgeItemTag(prefix + color.getName());
            this.tagWithOptionalLegacy(tag);
        }
    }

    private void addColored(TagKey<Item> group, String pattern) {
        String prefix = group.location().getPath().toUpperCase(Locale.ENGLISH) + "_";
        for (DyeColor color : DyeColor.values()) {
            ResourceLocation key = new ResourceLocation("minecraft", pattern.replace("{color}", color.getName()));
            TagKey<Item> tag = this.getForgeItemTag(prefix + color.getName());
            Item item = (Item)BuiltInRegistries.ITEM.get(key);
            if (item == null || item == Items.AIR) {
                throw new IllegalStateException("Unknown vanilla item: " + String.valueOf(key));
            }
            this.tag(tag).add((Object)item);
        }
    }

    private void addColoredTags(Consumer<TagKey<Item>> consumer, TagKey<Item> group) {
        String prefix = group.location().getPath().toUpperCase(Locale.ENGLISH) + "_";
        for (DyeColor color : DyeColor.values()) {
            TagKey<Item> tag = this.getForgeItemTag(prefix + color.getName());
            consumer.accept(tag);
        }
    }

    private TagKey<Block> getForgeBlockTag(String name) {
        try {
            name = name.toUpperCase(Locale.ENGLISH);
            return (TagKey)Tags.Blocks.class.getDeclaredField(name).get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(Tags.Blocks.class.getName() + " is missing tag name: " + name);
        }
    }

    private TagKey<Item> getForgeItemTag(String name) {
        try {
            name = name.toUpperCase(Locale.ENGLISH);
            return (TagKey)Tags.Items.class.getDeclaredField(name).get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(Tags.Items.class.getName() + " is missing tag name: " + name);
        }
    }

    public String getName() {
        return "NeoForge Item Tags";
    }

    private static /* synthetic */ void lambda$addTags$1(IntrinsicHolderTagsProvider.IntrinsicTagAppender rec$, TagKey xva$0) {
        rec$.addTags(new TagKey[]{xva$0});
    }

    private static /* synthetic */ void lambda$addTags$0(IntrinsicHolderTagsProvider.IntrinsicTagAppender rec$, TagKey xva$0) {
        rec$.addTags(new TagKey[]{xva$0});
    }
}

