/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.loot;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.neoforged.neoforge.common.ToolAction;

public class CanToolPerformAction
implements LootItemCondition {
    public static MapCodec<CanToolPerformAction> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ToolAction.CODEC.fieldOf("action").forGetter(action -> action.action)).apply((Applicative)builder, CanToolPerformAction::new));
    public static final LootItemConditionType LOOT_CONDITION_TYPE = new LootItemConditionType(CODEC);
    final ToolAction action;

    public CanToolPerformAction(ToolAction action) {
        this.action = action;
    }

    public LootItemConditionType getType() {
        return LOOT_CONDITION_TYPE;
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of((Object)LootContextParams.TOOL);
    }

    public boolean test(LootContext lootContext) {
        ItemStack itemstack = (ItemStack)lootContext.getParamOrNull(LootContextParams.TOOL);
        return itemstack != null && itemstack.canPerformAction(this.action);
    }

    public static LootItemCondition.Builder canToolPerformAction(ToolAction action) {
        return () -> new CanToolPerformAction(action);
    }
}

